/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.report;

import android.content.Context;
import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.a;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.DownParamInfo;
import com.abupdate.iot_libs.info.ErrorFileParamInfo;
import com.abupdate.iot_libs.info.PushMessageInfo;
import com.abupdate.iot_libs.info.UpgradeParamInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IReportResultCallback;
import com.abupdate.iot_libs.report.b;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.d;
import com.abupdate.iot_libs.utils.i;
import com.abupdate.trace.Trace;
import java.io.File;
import java.util.List;

public class ReportManager {
    private static String TAG = "ReportManager";
    private static ReportManager m_instance;
    private final Context m_context;
    private final b m_dbManager;

    private ReportManager(Context object) {
        b b2;
        ReportManager reportManager = reportManager2;
        ReportManager reportManager2 = object.getApplicationContext();
        reportManager.m_context = reportManager2;
        object = b2;
        b2 = new b((Context)reportManager2);
        reportManager.m_dbManager = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportManager getInstance(Context context) {
        if (m_instance != null) return m_instance;
        Class<ReportManager> clazz = ReportManager.class;
        synchronized (ReportManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new ReportManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_instance;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reportErrorLog(ErrorFileParamInfo errorFileParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string2 = a.a().a(errorFileParamInfo);
        }
        catch (FotaException fotaException) {
            iReportResultCallback.onReportFail();
            fotaException.printStackTrace();
            return;
        }
        {
            Trace.d((String)TAG, (String)("reportErrorLog(): " + (String)string2));
            if (TextUtils.isEmpty((CharSequence)string2)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (d.a(string2)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
    }

    public void reportDownParamInfo(int n, long l, String string2) {
        int n2;
        switch (n) {
            default: {
                n = 99;
                break;
            }
            case 0: {
                n = 1;
                break;
            }
            case -1: {
                n = 8;
                break;
            }
            case -4: 
            case -2: {
                n = 7;
            }
        }
        try {
            n2 = (int)new File(OtaAgentPolicy.config.updatePath).length();
        }
        catch (Exception exception) {
            n2 = 0;
        }
        ReportManager reportManager = string3;
        String string3 = OtaAgentPolicy.getVersionInfo().deltaID;
        String string4 = String.valueOf(n);
        long l2 = i.a();
        reportManager.saveReportData(new DownParamInfo(string3, string4, l, l2, n2, string2));
        OtaService.startByAction("action_report");
    }

    public void reportUpdateParamInfo(int n) {
        if (VersionInfo.getInstance().deltaID == null) {
            return;
        }
        switch (n) {
            default: {
                n = 99;
                break;
            }
            case 7005: {
                n = 5;
                break;
            }
            case 7004: {
                n = 3;
                break;
            }
            case 7003: {
                n = 2;
                break;
            }
            case 7002: {
                n = 4;
            }
        }
        ReportManager reportManager = string2;
        String string2 = DeviceInfo.getInstance().mid;
        String string3 = VersionInfo.getInstance().deltaID;
        String string4 = String.valueOf(n);
        reportManager.saveReportData(new UpgradeParamInfo(string2, string3, string4));
        OtaService.startByAction("action_report");
    }

    public int queryReport() {
        ReportManager reportManager = list;
        List<DownParamInfo> list = reportManager.m_dbManager.a();
        List<PushMessageInfo> list2 = reportManager.m_dbManager.c();
        List<ErrorFileParamInfo> list3 = reportManager.m_dbManager.b();
        return ((ReportManager)((Object)list)).m_dbManager.d().size() + list.size() + list2.size() + list3.size();
    }

    public b getDB() {
        return this.m_dbManager;
    }

    public void saveReportData(Object object) {
        if (object instanceof UpgradeParamInfo) {
            this.m_dbManager.a((UpgradeParamInfo)object);
        } else if (object instanceof DownParamInfo) {
            this.m_dbManager.a((DownParamInfo)object);
        }
    }

    public void savePushResponseData(PushMessageInfo pushMessageInfo) {
        this.m_dbManager.a(pushMessageInfo);
    }

    public void saveErrorFileData(ErrorFileParamInfo errorFileParamInfo) {
        this.m_dbManager.a(errorFileParamInfo);
    }

    public void report() {
        IReportResultCallback iReportResultCallback;
        List<Object> list = this.m_dbManager.a();
        int n = list.size();
        if (n > 0) {
            Trace.d((String)TAG, (String)("check the local report download: " + n));
        }
        for (final DownParamInfo downParamInfo : list) {
            IReportResultCallback iReportResultCallback2;
            iReportResultCallback = iReportResultCallback2;
            iReportResultCallback2 = new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() report down.");
                    ReportManager.this.m_dbManager.b(downParamInfo);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() report down.");
                    ReportManager.this.m_dbManager.b(downParamInfo);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() report down.");
                }
            };
            this.reportDown(downParamInfo, iReportResultCallback);
        }
        list = this.m_dbManager.d();
        int upgradeParamInfo = list.size();
        if (upgradeParamInfo > 0) {
            Trace.d((String)TAG, (String)("check the local report upgrade: " + upgradeParamInfo));
        }
        for (final UpgradeParamInfo pushMessageInfo : list) {
            IReportResultCallback iReportResultCallback3;
            iReportResultCallback = iReportResultCallback3;
            iReportResultCallback3 = new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() upgrade");
                    ReportManager.this.m_dbManager.b(pushMessageInfo);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() upgrade.");
                    ReportManager.this.m_dbManager.b(pushMessageInfo);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() upgrade.");
                }
            };
            this.reportUpgrade(pushMessageInfo, iReportResultCallback);
        }
        list = this.m_dbManager.c();
        int errorFileParamInfo = list.size();
        if (errorFileParamInfo > 0) {
            Trace.d((String)TAG, (String)("check push message data:" + errorFileParamInfo));
        }
        for (final PushMessageInfo pushMessageInfo : list) {
            IReportResultCallback iReportResultCallback4;
            iReportResultCallback = iReportResultCallback4;
            iReportResultCallback4 = new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() push");
                    ReportManager.this.m_dbManager.b(pushMessageInfo);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() push");
                    ReportManager.this.m_dbManager.b(pushMessageInfo);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() push");
                }
            };
            this.reportPushData(pushMessageInfo, iReportResultCallback);
        }
        list = this.m_dbManager.b();
        int n2 = list.size();
        if (n2 > 0) {
            Trace.d((String)TAG, (String)("check error log report data:" + n2));
            for (final ErrorFileParamInfo errorFileParamInfo2 : list) {
                IReportResultCallback iReportResultCallback5;
                iReportResultCallback = iReportResultCallback5;
                iReportResultCallback5 = new IReportResultCallback(){

                    @Override
                    public void onReportSuccess() {
                        Trace.d((String)TAG, (String)"onReportSuccess() error log");
                        ReportManager.this.m_dbManager.b(errorFileParamInfo2);
                        new File(errorFileParamInfo2.uploadFile).delete();
                    }

                    @Override
                    public void onReportFail() {
                        Trace.d((String)TAG, (String)"onReportFail() error log");
                        ReportManager.this.m_dbManager.b(errorFileParamInfo2);
                        new File(errorFileParamInfo2.uploadFile).delete();
                    }

                    @Override
                    public void onReportNetFail() {
                        Trace.d((String)TAG, (String)"onReportNetFail() error log");
                        if (TextUtils.isEmpty((CharSequence)errorFileParamInfo2.deltaID)) {
                            ReportManager.this.m_dbManager.b(errorFileParamInfo2);
                            new File(errorFileParamInfo2.uploadFile).delete();
                        }
                    }
                };
                this.reportErrorLog(errorFileParamInfo2, iReportResultCallback);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportDown(DownParamInfo downParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string2 = a.a().a(downParamInfo);
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
        {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (d.a(string2)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportUpgrade(UpgradeParamInfo upgradeParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string2 = a.a().a(upgradeParamInfo);
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
        {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (d.a(string2)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reportPushData(PushMessageInfo pushMessageInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string2 = a.a().a(pushMessageInfo.msgId);
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
        {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (d.a(string2)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
    }
}

