/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.info;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;

public class ProductInfo {
    private static final String TAG = "ProductInfo";
    private static ProductInfo mInstance;
    public String productId;
    public String productSecret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProductInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<ProductInfo> clazz = ProductInfo.class;
        synchronized (ProductInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ProductInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init() throws FotaException {
        try {
            ApplicationInfo applicationInfo = OtaAgentPolicy.sCx.getPackageManager().getApplicationInfo(OtaAgentPolicy.sCx.getPackageName(), 128);
            Object object = null;
            Object object2 = null;
            if (null != applicationInfo && applicationInfo.metaData != null) {
                object = applicationInfo.metaData.get("fota_configuration_product_id");
                object2 = applicationInfo.metaData.get("fota_configuration_product_secret");
            }
            if (null == object && null == object2) {
                this.initFromLocal();
            } else {
                String string = (String)object;
                String string2 = (String)object2;
                if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || !string.startsWith("string/") || !string2.startsWith("string/")) {
                    this.productId = "";
                    this.productSecret = "";
                } else {
                    this.productId = string.replace("string/", "").trim();
                    this.productSecret = string2.replace("string/", "").trim();
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new FotaException(nameNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new FotaException(203, (Throwable)nullPointerException);
        }
    }

    public boolean isProductValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.productSecret)) {
            Trace.d((String)TAG, (String)"isValid() product_secret = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() product id = null");
            bl = false;
        }
        return bl;
    }

    private void initFromLocal() {
        this.productId = SPFTool.getString(SPFTool.KEY_PRODUCT_ID, "");
        this.productSecret = SPFTool.getString("key_product_secret", "");
    }

    public void setAndStoreProductInfo(String string, String string2) {
        SPFTool.putString(SPFTool.KEY_PRODUCT_ID, string);
        SPFTool.putString("key_product_secret", string2);
        ProductInfo.getInstance().productId = string;
        ProductInfo.getInstance().productSecret = string2;
    }

    public void reset() {
        Trace.d((String)TAG, (String)"product info reset");
        this.productId = "";
        this.productSecret = "";
        SPFTool.putString(SPFTool.KEY_PRODUCT_ID, "");
        SPFTool.putString("key_product_secret", "");
    }
}

