/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.inter;

import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.engine.f;
import com.abupdate.iot_libs.inter.IListener;
import com.abupdate.iot_libs.inter.ILoginCallback;
import com.abupdate.iot_libs.inter.IStatusListener;
import com.abupdate.iot_libs.inter.MessageListener;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.IMqttToken;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OtaListener
implements MessageListener.ConnectionLostListener,
IMqttActionListener {
    private static final String TAG = "OtaListener";
    private static OtaListener mInstance;
    Object mLock = new Object();
    List<Action> subAction = new ArrayList<Action>();
    Action[] allSubAction = new Action[]{Action.SUB_LOGIN, Action.SUB_LOGOUT, Action.SUB_NOTIFY};
    private int reSubCount = 3;
    private Action action;
    private Map<Enum, List<IListener>> listeners = new HashMap<Enum, List<IListener>>();

    @Override
    public void onConnectLost(int n) {
        List<IListener> list = this.getListener(Action.CONNECT);
        if (-1 == n) {
            if (list != null) {
                for (IListener iListener : list) {
                    ((IStatusListener)iListener).onDisconnected();
                }
            }
        } else {
            if (list != null) {
                for (IListener iListener : list) {
                    ((IStatusListener)iListener).onAbnormalDisconnected(n);
                }
            }
            if (5 != n && 4 != n) {
                MqttManager.getInstance().keepConnect(1800000L, System.currentTimeMillis() + 30000L);
            }
        }
        this.setAction(Action.CONNECT);
        b.a().a(b.a.g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OtaListener getInstance() {
        if (mInstance != null) return mInstance;
        Class<OtaListener> clazz = OtaListener.class;
        synchronized (OtaListener.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OtaListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public OtaListener setAction(Action action) {
        this.action = action;
        if (Action.CONNECT == action) {
            MessageListener.getInstance().setConnectionLostListener(this);
        }
        return this;
    }

    private OtaListener() {
    }

    public void addListener(Action action, IListener iListener) {
        if (!this.listeners.containsKey((Object)action)) {
            this.listeners.put(action, new ArrayList());
        }
        this.listeners.get((Object)action).add(iListener);
    }

    public void removeAllListener(Action action) {
        if (this.listeners.containsKey((Object)action)) {
            this.listeners.get((Object)action).clear();
        }
    }

    public boolean removeListener(Action action, IListener iListener) {
        if (this.listeners.containsKey((Object)action)) {
            boolean bl = this.listeners.get((Object)action).remove(iListener);
            return bl;
        }
        return false;
    }

    public void onSuccess(IMqttToken iMqttToken) {
        switch (this.action) {
            case CONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket connect success");
                this.connect();
                break;
            }
            case DISCONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket disconnect success");
                this.disConnect();
                break;
            }
            case PUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onSuccess() pub report deviceinfo");
                break;
            }
            case PUB_LOGIN: {
                Trace.d((String)TAG, (String)"onSuccess() pub login");
                break;
            }
            case PUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onSuccess() pub logout");
                break;
            }
            case SUB_LOGIN: {
                this.lockNotify();
                this.addSubAction(Action.SUB_LOGIN);
                break;
            }
            case SUB_LOGOUT: {
                this.lockNotify();
                this.addSubAction(Action.SUB_LOGOUT);
                break;
            }
            case SUB_NOTIFY: {
                this.lockNotify();
                this.addSubAction(Action.SUB_NOTIFY);
                break;
            }
            case SUB_REPORT_DEVICEINFO: {
                this.lockNotify();
            }
        }
    }

    private void disConnect() {
    }

    private void connect() {
        b.a().a(b.a.c);
        List<IListener> list = this.getListener(Action.CONNECT);
        this.doLogin(list);
    }

    private void doLogin(final List<IListener> list) {
        f.a().a(new Runnable(){

            @Override
            public void run() {
                OtaListener.this.subTask();
                if (OtaListener.this.subAction.size() == OtaListener.this.allSubAction.length) {
                    b.a().b(new ILoginCallback(){

                        @Override
                        public void onLoginSuccess() {
                            if (list != null) {
                                for (IListener iListener : list) {
                                    ((IStatusListener)iListener).onConnected();
                                }
                            }
                        }

                        @Override
                        public void onLoginFail(int n) {
                            OtaService.selfDisconnect();
                        }

                        @Override
                        public void onLoginTimeout() {
                            OtaService.selfDisconnect();
                        }
                    });
                } else {
                    OtaService.selfDisconnect();
                }
            }
        });
    }

    private List<IListener> getListener(Action action) {
        List<IListener> list = this.listeners.get((Object)action);
        return list;
    }

    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
        switch (this.action) {
            case CONNECT: {
                Trace.d((String)TAG, (String)"onFailure() connect");
                this.connect(throwable);
                break;
            }
            case DISCONNECT: {
                Trace.d((String)TAG, (String)"onFailure() disconnect");
                this.disconnect(throwable);
                break;
            }
            case PUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onFailure() pub report deviceinfo");
                break;
            }
            case PUB_LOGIN: {
                Trace.d((String)TAG, (String)"onFailure() pub login");
                break;
            }
            case PUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onFailure() pub logout");
                break;
            }
            case SUB_LOGIN: {
                Trace.d((String)TAG, (String)"onFailure() sub login");
                this.lockNotify();
                break;
            }
            case SUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onFailure() sub logout");
                this.lockNotify();
                break;
            }
            case SUB_NOTIFY: {
                Trace.d((String)TAG, (String)"onFailure() sub notify");
                this.lockNotify();
                break;
            }
            case SUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onFailure() sub report deviceinfo");
                this.lockNotify();
            }
        }
    }

    public void disconnect(Throwable throwable) {
        b.a().a(b.a.g);
        List<IListener> list = this.getListener(Action.CONNECT);
        if (list != null) {
            for (IListener iListener : list) {
                ((IStatusListener)iListener).onError(this.getError(throwable));
            }
        }
        if (null == throwable) {
            return;
        }
        Trace.e((String)TAG, (String)("disconnect() exception:" + throwable.toString()));
        throwable.printStackTrace();
    }

    public void connect(Throwable throwable) {
        b.a().a(b.a.g);
        List<IListener> list = this.getListener(Action.CONNECT);
        if (list != null) {
            for (IListener iListener : list) {
                ((IStatusListener)iListener).onError(this.getError(throwable));
            }
        }
        if (null != throwable) {
            throwable.printStackTrace();
            Trace.e((String)TAG, (String)("connect() " + throwable.toString()));
        }
        if (MqttManager.getInstance().isConneect() || b.a().b() == b.a.b) {
            return;
        }
        if (5 != this.getError(throwable) && 4 != this.getError(throwable)) {
            MqttManager.getInstance().keepConnect(1800000L, System.currentTimeMillis() + 30000L);
        }
    }

    private int getError(Throwable throwable) {
        if (throwable instanceof MqttException) {
            MqttException mqttException = (MqttException)throwable;
            return mqttException.getReasonCode();
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockNotify() {
        if (this.mLock != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadLock() {
        if (this.mLock != null) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    private void addSubAction(Action action) {
        if (null == this.subAction) {
            return;
        }
        if (!this.subAction.contains((Object)action)) {
            this.subAction.add(action);
        }
    }

    private void subTask() {
        while (this.reSubCount > 0 && this.subAction.size() < this.allSubAction.length) {
            --this.reSubCount;
            if (null == this.allSubAction || this.allSubAction.length == 0) {
                return;
            }
            for (int k = 0; k < this.allSubAction.length; ++k) {
                if (this.subAction.contains((Object)this.allSubAction[k])) continue;
                if (this.allSubAction[k] == Action.SUB_LOGIN) {
                    b.a().d();
                    this.threadLock();
                    continue;
                }
                if (this.allSubAction[k] == Action.SUB_LOGOUT) {
                    b.a().e();
                    this.threadLock();
                    continue;
                }
                if (this.allSubAction[k] != Action.SUB_NOTIFY) continue;
                b.a().f();
                this.threadLock();
            }
        }
        this.reSubCount = 3;
    }

    public static enum Action {
        CONNECT,
        DISCONNECT,
        PUB_REPORT_DEVICEINFO,
        PUB_LOGIN,
        PUB_LOGOUT,
        SUB_LOGIN,
        SUB_LOGOUT,
        SUB_NOTIFY,
        SUB_REPORT_DEVICEINFO;

    }
}

