/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.inter.IReportDeviceStatusCallback;
import com.abupdate.iot_libs.inter.IStatusListener;
import com.abupdate.iot_libs.inter.MessageListener;
import com.abupdate.iot_libs.inter.OtaListener;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class MqttAgentPolicy {
    static AlarmManager alarmManager;
    private static final String TAG = "MqttAgentPolicy";
    private static final String CONNECT = "connect";
    private static final String DISCONNECT = "disconnect";
    public static final String CONNECT_ACTION = "com.abupdate.mqtt.action_connect";
    public static final String DISCONNECT_ACTION = "com.abupdate.mqtt.action_disconnect";
    public static final String RESET_MQTT_ACTION = "com.abupdate.mqtt.action_reset_mqtt";
    public static final String CONFIG_MQTT_CONNECT = "config_mqtt_connect";
    private static final long ONE_HOUR_IN_MILLS = 3600000L;
    private static final long ONE_DAY_IN_MILLS = 86400000L;
    private static int continuousTime;
    private static final int MQTT_POLICY_RESET_CODE = 25;
    private static ArrayList<Integer> oldStatusList;

    public static void initMqtt() {
        MqttManager.getInstance().setContext(OtaAgentPolicy.sCx);
        MqttManager.getInstance().registerMessageListener((MqttCallback)MessageListener.getInstance());
        MqttManager.getInstance().setTraceEnable(false);
        if ("ture".equals(DeviceInfo.getInstance().requestPush)) {
            MqttAgentPolicy.connect();
        }
    }

    public static void registerStatusListener(IStatusListener iStatusListener) {
        OtaListener.getInstance().addListener(OtaListener.Action.CONNECT, iStatusListener);
    }

    public static boolean unregisterStatusListener(IStatusListener iStatusListener) {
        return OtaListener.getInstance().removeListener(OtaListener.Action.CONNECT, iStatusListener);
    }

    public static void disConnect() {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", DISCONNECT, "--------------------------"});
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT, false);
        OtaService.selfDisconnect();
    }

    public static void stopKeepConnect() {
        Trace.d((String)TAG, (String)"stopKeepConnect() start.");
        if (MqttManager.getInstance().isKeepConnect()) {
            OtaService.startByAction("action_disconnect");
        } else {
            Trace.d((String)TAG, (String)"stopKeepConnect() is not config keep connect!");
        }
    }

    public static void connect() {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", CONNECT, "--------------------------"});
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT, true);
        if (MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"connect() is connected");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connected")));
            return;
        }
        if (b.a().b() == b.a.b) {
            Trace.d((String)TAG, (String)"connect() is connecting");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connecting")));
            return;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.d((String)TAG, (String)"connect() params is not valid");
            return;
        }
        OtaService.startByAction("action_connect");
    }

    public static void setDelayMqttPolicy(Context context, String string) {
        oldStatusList = new ArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (string.length() == 4) {
            calendar.set(11, Integer.parseInt(string.substring(0, 2)));
            long l = calendar.getTime().getTime() + 10000L;
            calendar.set(11, Integer.parseInt(string.substring(2, 4)));
            long l2 = calendar.getTime().getTime() - 10000L;
            if (l < System.currentTimeMillis()) {
                l += 86400000L;
            }
            MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(string.substring(0, 2)), l, CONNECT);
            if (l2 < System.currentTimeMillis()) {
                l2 += 86400000L;
            }
            MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(string.substring(2, 4)), l2, DISCONNECT);
            MqttAgentPolicy.resetDelayMqttTask(context);
        } else {
            String[] stringArray = string.split(",");
            long[] lArray = new long[stringArray.length];
            long[] lArray2 = new long[stringArray.length];
            for (int k = 0; k < stringArray.length; ++k) {
                int n;
                calendar.set(11, Integer.parseInt(stringArray[k]));
                lArray[k] = calendar.getTimeInMillis() - 3600000L + 10000L;
                lArray2[k] = calendar.getTimeInMillis() - 10000L;
                Trace.d((String)TAG, (String)("Set Delay Mqtt Task:  " + (Integer.parseInt(stringArray[k]) - 1) + "--------------------------" + stringArray[k]));
                if (lArray[k] > System.currentTimeMillis()) {
                    MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray[k], CONNECT);
                    for (n = k + 1; n < stringArray.length && Integer.parseInt(stringArray[n]) - Integer.parseInt(stringArray[n - 1]) == 1; ++n) {
                        ++continuousTime;
                    }
                    int n2 = k;
                    lArray2[n2] = lArray2[n2] + (long)continuousTime * 3600000L;
                    MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray2[k], DISCONNECT);
                    if (continuousTime <= 0) continue;
                    k += continuousTime;
                    continuousTime = 0;
                    continue;
                }
                if (lArray[k] < System.currentTimeMillis() && lArray2[k] > System.currentTimeMillis()) {
                    MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray[k] + 86400000L, CONNECT);
                    for (n = k + 1; n < stringArray.length && Integer.parseInt(stringArray[n]) - Integer.parseInt(stringArray[n - 1]) == 1; ++n) {
                        ++continuousTime;
                    }
                    int n3 = k;
                    lArray2[n3] = lArray2[n3] + (long)continuousTime * 3600000L;
                    MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray2[k], DISCONNECT);
                    if (continuousTime <= 0) continue;
                    k += continuousTime;
                    continuousTime = 0;
                    continue;
                }
                if (lArray[k] >= System.currentTimeMillis() || lArray2[k] >= System.currentTimeMillis()) continue;
                MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray[k] + 86400000L, CONNECT);
                for (n = k + 1; n < stringArray.length && Integer.parseInt(stringArray[n]) - Integer.parseInt(stringArray[n - 1]) == 1; ++n) {
                    ++continuousTime;
                }
                int n4 = k;
                lArray2[n4] = lArray2[n4] + ((long)continuousTime * 3600000L + 86400000L);
                MqttAgentPolicy.setDelayMqttTask(context, Integer.parseInt(stringArray[k]), lArray2[k], DISCONNECT);
                if (continuousTime <= 0) continue;
                k += continuousTime;
                continuousTime = 0;
            }
            MqttAgentPolicy.resetDelayMqttTask(context);
        }
    }

    public static void reportDeviceStatus(String string, IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"reportDeviceStatus() is disconnected");
            return;
        }
        if (b.a().b() != b.a.d) {
            Trace.e((String)TAG, (String)"reportDeviceStatus() device is off line");
            return;
        }
        b.a().a(string, iReportDeviceStatusCallback);
    }

    public static boolean isConnected() {
        return MqttManager.getInstance().isConneect();
    }

    private static void setDelayMqttTask(Context context, int n, long l, String string) {
        oldStatusList.add(n);
        if (Build.VERSION.SDK_INT >= 19) {
            if (string.equals(CONNECT)) {
                alarmManager.setExact(0, l, PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(CONNECT_ACTION), (int)0x8000000));
            } else {
                alarmManager.setExact(0, l, PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(DISCONNECT_ACTION), (int)0x8000000));
            }
        } else if (string.equals(CONNECT)) {
            alarmManager.set(0, l, PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(CONNECT_ACTION), (int)0x8000000));
        } else {
            alarmManager.set(0, l, PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(DISCONNECT_ACTION), (int)0x8000000));
        }
        Trace.d((String)TAG, (String)("setDelayMqttTask()\uff1a " + string + ", " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).format(l) + "\uff0c requestCode: " + n));
    }

    private static void cancelDelayMqttTask(Context context, int n, String string) {
        if (string.equals(CONNECT)) {
            alarmManager.cancel(PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(CONNECT_ACTION), (int)0x8000000));
            Trace.d((String)TAG, (String)("cancel Delay Mqtt Connect: " + n));
        } else {
            alarmManager.cancel(PendingIntent.getBroadcast((Context)context, (int)n, (Intent)new Intent(DISCONNECT_ACTION), (int)0x8000000));
            Trace.d((String)TAG, (String)("cancel Delay Mqtt DisConnect: " + n));
        }
    }

    public static void cancelDelayMqttTask(Context context) {
        if (oldStatusList != null && oldStatusList.size() != 0) {
            for (Integer n : oldStatusList) {
                MqttAgentPolicy.cancelDelayMqttTask(context, n, CONNECT);
                MqttAgentPolicy.cancelDelayMqttTask(context, n, DISCONNECT);
            }
        }
    }

    public static void resetDelayMqttTask(Context context) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(11, 24);
        Long l = calendar.getTimeInMillis() + 30000L;
        if (Build.VERSION.SDK_INT >= 19) {
            alarmManager.setExact(0, l.longValue(), PendingIntent.getBroadcast((Context)context, (int)25, (Intent)new Intent(RESET_MQTT_ACTION), (int)0x8000000));
        } else {
            alarmManager.set(0, l.longValue(), PendingIntent.getBroadcast((Context)context, (int)25, (Intent)new Intent(RESET_MQTT_ACTION), (int)0x8000000));
        }
        Trace.d((String)TAG, (String)("setDelayMqttTask()\uff1a reset mqtt action, " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).format(l) + "\uff0c requestCode: " + 25));
    }

    static {
        continuousTime = 0;
    }
}

