/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.inter.IReportDeviceStatusCallback;
import com.abupdate.iot_libs.inter.IStatusListener;
import com.abupdate.iot_libs.inter.MessageListener;
import com.abupdate.iot_libs.inter.OtaListener;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;

public class MqttAgentPolicy {
    private static final String TAG = "MqttAgentPolicy";
    public static final String CONFIG_MQTT_CONNECT = "config_mqtt_connect";

    public static void initMqtt() {
        MqttManager.getInstance().setContext(OtaAgentPolicy.sCx);
        MqttManager.getInstance().registerMessageListener((MqttCallback)MessageListener.getInstance());
        MqttManager.getInstance().setTraceEnable(false);
    }

    public static void registerStatusListener(IStatusListener iStatusListener) {
        OtaListener.getInstance().addListener(OtaListener.Action.CONNECT, iStatusListener);
    }

    public static boolean unregisterStatusListener(IStatusListener iStatusListener) {
        return OtaListener.getInstance().removeListener(OtaListener.Action.CONNECT, iStatusListener);
    }

    public static void disConnect() {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "disconnect", "--------------------------"});
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT, false);
        OtaService.selfDisconnect();
    }

    public static void stopKeepConnect() {
        Trace.d((String)TAG, (String)"stopKeepConnect() start.");
        if (MqttManager.getInstance().isKeepConnect()) {
            OtaService.startByAction("action_disconnect");
        } else {
            Trace.d((String)TAG, (String)"stopKeepConnect() is not config keep connect!");
        }
    }

    public static void connect() {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "connect", "--------------------------"});
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT, true);
        if (MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"connect() is connected");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connected")));
            return;
        }
        if (b.a().b() == b.a.b) {
            Trace.d((String)TAG, (String)"connect() is connecting");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connecting")));
            return;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.d((String)TAG, (String)"connect() params is not valid");
            return;
        }
        OtaService.startByAction("action_connect");
    }

    public static void reportDeviceStatus(String string, IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"reportDeviceStatus() is disconnected");
            return;
        }
        if (b.a().b() != b.a.d) {
            Trace.e((String)TAG, (String)"reportDeviceStatus() device is off line");
            return;
        }
        b.a().a(string, iReportDeviceStatusCallback);
    }

    public static boolean isConnected() {
        return MqttManager.getInstance().isConneect();
    }
}

