/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import android.content.Context;
import com.abupdate.iot_libs.info.CustomDeviceInfo;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.a;
import com.abupdate.trace.Trace;
import org.json.JSONObject;

public class IndirectOtaAgentPolicy {
    private static final String TAG = "IndirectOtaAgentPolicy";

    public static String getDeviceInfo() {
        Trace.d((String)TAG, (String)"getDeviceInfo() ");
        return DeviceInfo.getInstance().toString();
    }

    public static CustomDeviceInfo setDeviceInfo(String string) {
        Trace.d((String)TAG, (String)("setDeviceInfo() device info:" + string));
        CustomDeviceInfo customDeviceInfo = new CustomDeviceInfo();
        try {
            JSONObject jSONObject = new JSONObject(string);
            customDeviceInfo.mid = jSONObject.getString("mid");
            customDeviceInfo.version = jSONObject.getString("version");
            customDeviceInfo.oem = jSONObject.getString("oem");
            customDeviceInfo.models = jSONObject.getString("models");
            customDeviceInfo.platform = jSONObject.getString("platform");
            customDeviceInfo.deviceType = jSONObject.getString("deviceType");
            customDeviceInfo.productId = jSONObject.getString("productId");
            customDeviceInfo.product_secret = jSONObject.getString("productSecret");
        }
        catch (Exception exception) {
            Trace.e((String)TAG, (Throwable)exception);
        }
        return customDeviceInfo;
    }

    public static boolean resetDeviceInfo(String string) {
        Trace.d((String)TAG, (String)("resetDeviceInfo() device info:" + string));
        try {
            JSONObject jSONObject = new JSONObject(string);
            DeviceInfo.getInstance().mid = jSONObject.getString("mid");
            DeviceInfo.getInstance().version = jSONObject.getString("version");
            DeviceInfo.getInstance().oem = jSONObject.getString("oem");
            DeviceInfo.getInstance().models = jSONObject.getString("models");
            DeviceInfo.getInstance().platform = jSONObject.getString("platform");
            DeviceInfo.getInstance().deviceType = jSONObject.getString("deviceType");
            ProductInfo.getInstance().productId = jSONObject.getString("productId");
            ProductInfo.getInstance().productSecret = jSONObject.getString("productSecret");
        }
        catch (Exception exception) {
            Trace.e((String)TAG, (Throwable)exception);
        }
        return DeviceInfo.getInstance().isValid();
    }

    public static String getVersionInfo() {
        Trace.d((String)TAG, (String)"getVersionInfo() ");
        String string = SPFTool.getString("key_version_info", "");
        return string;
    }

    public static void setVersionInfo(String string) {
        Trace.d((String)TAG, (String)("setVersionInfo() version info:" + string));
        a.a(string);
    }

    public static void reportUpdate(Context context, boolean bl) {
        Trace.d((String)TAG, (String)("reportUpdate() result:" + bl));
        ReportManager.getInstance(context).reportUpdateParamInfo(bl ? 1 : 99);
    }
}

