/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.RecoverySystem;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.abupdate.iot_download_libs.DLManager;
import com.abupdate.iot_download_libs.IOnDownListener;
import com.abupdate.iot_libs.MqttAgentPolicy;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.engine.i;
import com.abupdate.iot_libs.engine.n;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.RegisterInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.OtaListener;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.service.b;
import com.abupdate.iot_libs.service.c;
import com.abupdate.iot_libs.service.d;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class OtaService
extends IntentService {
    public static final String TAG = "OtaService";
    public static final String ACTION_REGISTER = "action_register";
    public static final String ACTION_CHECK_VERSION = "action_check_version";
    public static final String ACTION_CONNECT = "action_connect";
    public static final String ACTION_DISCONNECT = "action_disconnect";
    public static final String ACTION_DOWNLOAD = "action_download";
    public static final String ACTION_UPDATE = "action_update";
    public static final String ACTION_REPORT = "action_report";
    public static final String ACTION_STATIC_CHECK_VERSION = "action_static_check_version";
    private static Context a;
    private Handler b;
    private static long c;
    private static String d;

    public OtaService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.b = new Handler();
        if (null == com.abupdate.iot_libs.engine.c.a().a) {
            com.abupdate.iot_libs.engine.c.a().a = this.b;
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onHandleIntent(@Nullable Intent object) {
        if (object == null) {
            return;
        }
        switch (object.getStringExtra("key_action")) {
            case "action_register": {
                if (a == null) {
                    Trace.e((String)TAG, (String)"register_task() context is null,please call method initContext() in application!");
                    return;
                }
                int n2 = i.a().d();
                if (com.abupdate.iot_libs.utils.d.a(n2)) {
                    com.abupdate.iot_libs.engine.c.a();
                    com.abupdate.iot_libs.engine.c.b();
                    return;
                }
                com.abupdate.iot_libs.engine.c.a().a(n2);
                return;
            }
            case "action_check_version": {
                int n3 = i.a().c();
                if (com.abupdate.iot_libs.utils.d.a(n3)) {
                    com.abupdate.iot_libs.engine.c.a().c();
                    return;
                }
                com.abupdate.iot_libs.engine.c.a().a(n3);
                return;
            }
            case "action_static_check_version": {
                try {
                    i.a().b();
                    return;
                }
                catch (FotaException fotaException) {
                    fotaException.printStackTrace();
                    return;
                }
            }
            case "action_connect": {
                int n4;
                if (!(!TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceSecret) && !TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceId) || 1000 == (n4 = i.a().d()) && RegisterInfo.getInstance().isValid())) {
                    Trace.e((String)TAG, (String)"connectMqtt() failed");
                    return;
                }
                com.abupdate.iot_libs.a.b.a().a(b.a.b);
                com.abupdate.iot_libs.a.b.a();
                com.abupdate.iot_libs.a.b.c();
                return;
            }
            case "action_disconnect": {
                object = this;
                if (MqttAgentPolicy.isConnected()) {
                    if (com.abupdate.iot_libs.a.b.a().b() == b.a.d) {
                        com.abupdate.iot_libs.a.b.a().a(b.a.f);
                        com.abupdate.iot_libs.a.b.a().a(new c((OtaService)((Object)object)));
                        return;
                    }
                    com.abupdate.iot_libs.a.b.a().a(b.a.f);
                    com.abupdate.iot_libs.a.b.a();
                    com.abupdate.iot_libs.a.b.a(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
                    return;
                }
                if (MqttManager.getInstance().isKeepConnect()) {
                    com.abupdate.iot_libs.a.b.a();
                    com.abupdate.iot_libs.a.b.a(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
                }
                return;
            }
            case "action_download": {
                object = this;
                c = System.currentTimeMillis() / 1000L;
                if (new File(OtaAgentPolicy.config.updatePath).exists() && com.abupdate.iot_libs.utils.c.a(OtaAgentPolicy.config.updatePath, VersionInfo.getInstance().md5sum)) {
                    ReportManager.getInstance(OtaAgentPolicy.sCx).reportDownParamInfo(0, c, "");
                    com.abupdate.iot_libs.engine.c.a().a(4, 0L, 0L, 0);
                    return;
                }
                DLManager dLManager = DLManager.getInstance();
                i.a();
                dLManager.add(i.e());
                DLManager.getInstance().execAsync((IOnDownListener)new b((OtaService)((Object)object)));
                return;
            }
            case "action_update": {
                object = object.getStringExtra("key_extra_info");
                if (object != null) {
                    this.rebootLocalUpgrade((String)object);
                    return;
                }
                Trace.d((String)TAG, (String)"upgrade() start.");
                object = OtaAgentPolicy.config.updatePath;
                Trace.d((String)TAG, (String)("rebootUpgrade() path:" + (String)object));
                if (!com.abupdate.iot_libs.utils.c.a((String)object, VersionInfo.getInstance().md5sum)) {
                    Trace.e((String)TAG, (String)"onUpdateFail() . update validate file fail");
                    com.abupdate.iot_libs.engine.c.a().b(7005);
                    ReportManager.getInstance(a).reportUpdateParamInfo(7005);
                    return;
                }
                OtaService.a(new File((String)object));
                return;
            }
            case "action_report": {
                if (!DeviceInfo.getInstance().isValid()) break;
                ReportManager.getInstance(a).report();
            }
        }
    }

    public void rebootLocalUpgrade(String string) {
        Trace.d((String)TAG, (String)("rebootLocalUpgrade() path:" + string));
        if (TextUtils.isEmpty((CharSequence)string)) {
            Trace.e((String)TAG, (String)"rebootLocalUpgrade() path is null");
            com.abupdate.iot_libs.engine.c.a().b(7002);
            ReportManager.getInstance(a).reportUpdateParamInfo(7002);
            return;
        }
        OtaService.a(new File(string));
    }

    private static void a(File file) {
        if (!com.abupdate.iot_libs.engine.c.d().rebootConditionPrepare()) {
            Trace.d((String)TAG, (String)"startUpdate() update conditions does not meet");
            com.abupdate.iot_libs.engine.c.d().onError(7006);
            return;
        }
        if (file.getAbsoluteFile() != null && OtaAgentPolicy.getVersionInfo().versionName != null && OtaAgentPolicy.getVersionInfo().deltaID != null) {
            SPFTool.putString("key_update_file_path", file.getAbsolutePath());
            SPFTool.putString("key_version_name", OtaAgentPolicy.getVersionInfo().versionName);
            SPFTool.putString("KEY_DELTAID", OtaAgentPolicy.getVersionInfo().deltaID);
            SPFTool.putLong("key_last_recovery_time", System.currentTimeMillis());
            Trace.d((String)TAG, (String)("rebootUpgrade() version_name = " + SPFTool.getString("key_version_name", "null") + ",deltaId:" + SPFTool.getString("KEY_DELTAID", "null")));
        }
        try {
            RecoverySystem.installPackage((Context)a, (File)file);
            return;
        }
        catch (IOException iOException) {
            Trace.e((String)TAG, (String)"onUpdateFail() .", (Throwable)iOException);
            com.abupdate.iot_libs.engine.c.a().b(7004);
            ReportManager.getInstance(a).reportUpdateParamInfo(7004);
            return;
        }
    }

    public static void selfDisconnect() {
        if (MqttManager.getInstance().isKeepConnect()) {
            MqttManager.getInstance().stopKeepConnect();
            OtaService.startByAction(ACTION_DISCONNECT);
            return;
        }
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"disConnect() is disconnected");
            OtaListener.getInstance().disconnect(new MqttException(new Throwable("is disconnected")));
            return;
        }
        if (com.abupdate.iot_libs.a.b.a().b() == b.a.f) {
            Trace.d((String)"MqttAgentPolicy", (String)"disConnect() is disconnecting");
            OtaListener.getInstance().disconnect(new MqttException(new Throwable("is disconnecting")));
            return;
        }
        OtaService.startByAction(ACTION_DISCONNECT);
    }

    public static void startByAction(String string) {
        OtaService.startByAction(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startByAction(String string, @Nullable Object object) {
        Class<OtaService> clazz = OtaService.class;
        synchronized (OtaService.class) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                Trace.e((String)TAG, (String)"startByAction() action is null");
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
            if (a == null) {
                Trace.e((String)TAG, (String)"startByAction() context is null,should call initContext();");
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
            Intent intent = new Intent();
            intent.putExtra("key_action", string);
            intent.setClass(a, OtaService.class);
            if (object != null) {
                if (object instanceof Boolean) {
                    intent.putExtra("key_extra_info", (Serializable)((Boolean)object));
                }
                if (object instanceof Integer) {
                    intent.putExtra("key_extra_info", (Serializable)((Integer)object));
                }
                if (object instanceof String) {
                    intent.putExtra("key_extra_info", (String)object);
                }
            }
            a.startService(intent);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static void initContext(Context context) {
        a = context;
    }

    public static void setDownloadCancel() {
        DLManager.getInstance().cancel_all();
    }

    static /* synthetic */ void a(OtaService otaService) {
        n.a().a(new d(otaService));
    }

    static /* synthetic */ long a() {
        return c;
    }

    static /* synthetic */ String b() {
        return d;
    }

    static /* synthetic */ Context c() {
        return a;
    }

    static /* synthetic */ String a(String string) {
        d = string;
        return d;
    }

    static {
        d = "";
    }
}

