/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.report;

import android.content.Context;
import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.a;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.DownParamInfo;
import com.abupdate.iot_libs.info.ErrorFileParamInfo;
import com.abupdate.iot_libs.info.PushMessageInfo;
import com.abupdate.iot_libs.info.UpgradeParamInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IReportResultCallback;
import com.abupdate.iot_libs.report.b;
import com.abupdate.iot_libs.report.c;
import com.abupdate.iot_libs.report.d;
import com.abupdate.iot_libs.report.e;
import com.abupdate.iot_libs.report.f;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.trace.Trace;
import java.io.File;
import java.util.List;

public class ReportManager {
    private static String TAG = "ReportManager";
    private static ReportManager m_instance;
    private final Context m_context;
    private final b m_dbManager;

    private ReportManager(Context context) {
        this.m_context = context.getApplicationContext();
        this.m_dbManager = new b(this.m_context);
    }

    public void reportDownParamInfo(int n2, long l2, String string) {
        int n3;
        switch (n2) {
            case 0: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case -4: 
            case -2: {
                n2 = 7;
                break;
            }
            default: {
                n2 = 99;
            }
        }
        try {
            n3 = (int)new File(OtaAgentPolicy.config.updatePath).length();
        }
        catch (Exception exception) {
            n3 = 0;
        }
        DownParamInfo downParamInfo = new DownParamInfo(OtaAgentPolicy.getVersionInfo().deltaID, String.valueOf(n2), l2, System.currentTimeMillis() / 1000L, n3, string);
        this.saveReportData(downParamInfo);
        OtaService.startByAction("action_report");
    }

    public void reportUpdateParamInfo(int n2) {
        if (null == VersionInfo.getInstance().deltaID) {
            return;
        }
        switch (n2) {
            case 1: {
                n2 = 1;
                break;
            }
            case 7003: {
                n2 = 2;
                break;
            }
            case 7004: {
                n2 = 3;
                break;
            }
            case 7002: {
                n2 = 4;
                break;
            }
            case 7005: {
                n2 = 5;
                break;
            }
            default: {
                n2 = 99;
            }
        }
        UpgradeParamInfo upgradeParamInfo = new UpgradeParamInfo(DeviceInfo.getInstance().mid, VersionInfo.getInstance().deltaID, String.valueOf(n2));
        this.saveReportData(upgradeParamInfo);
        OtaService.startByAction("action_report");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportManager getInstance(Context context) {
        if (m_instance != null) return m_instance;
        Class<ReportManager> clazz = ReportManager.class;
        synchronized (ReportManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new ReportManager(context);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return m_instance;
        }
    }

    public int queryReport() {
        List<UpgradeParamInfo> list = this.m_dbManager.b();
        List<DownParamInfo> list2 = this.m_dbManager.a();
        List<PushMessageInfo> list3 = this.m_dbManager.c();
        List<ErrorFileParamInfo> list4 = this.m_dbManager.d();
        return list.size() + list2.size() + list3.size() + list4.size();
    }

    public b getDB() {
        return this.m_dbManager;
    }

    public void saveReportData(Object object) {
        if (object instanceof UpgradeParamInfo) {
            this.m_dbManager.a((UpgradeParamInfo)object);
            return;
        }
        if (object instanceof DownParamInfo) {
            this.m_dbManager.a((DownParamInfo)object);
        }
    }

    public void savePushResponseData(PushMessageInfo pushMessageInfo) {
        this.m_dbManager.b(pushMessageInfo);
    }

    public void saveErrorFileData(ErrorFileParamInfo errorFileParamInfo) {
        this.m_dbManager.b(errorFileParamInfo);
    }

    public void report() {
        List<DownParamInfo> list22 = this.m_dbManager.a();
        int n2 = list22.size();
        if (n2 > 0) {
            Trace.d((String)TAG, (String)("check the local report download: " + n2));
        }
        for (DownParamInfo downParamInfo : list22) {
            this.reportDown(downParamInfo, new c(this, downParamInfo));
        }
        List<UpgradeParamInfo> list = this.m_dbManager.b();
        n2 = list.size();
        if (n2 > 0) {
            Trace.d((String)TAG, (String)("check the local report upgrade: " + n2));
        }
        for (UpgradeParamInfo upgradeParamInfo : list) {
            this.reportUpgrade(upgradeParamInfo, new d(this, upgradeParamInfo));
        }
        List<PushMessageInfo> list2 = this.m_dbManager.c();
        n2 = list2.size();
        if (n2 > 0) {
            Trace.d((String)TAG, (String)("check push message data:" + n2));
        }
        for (PushMessageInfo pushMessageInfo : list2) {
            this.reportPushData(pushMessageInfo, new e(this, pushMessageInfo));
        }
        List<ErrorFileParamInfo> list3 = this.m_dbManager.d();
        n2 = list3.size();
        if (n2 > 0) {
            Trace.d((String)TAG, (String)("check error log report data:" + n2));
            for (ErrorFileParamInfo errorFileParamInfo : list3) {
                this.reportErrorLog(errorFileParamInfo, new f(this, errorFileParamInfo));
            }
        }
    }

    private void reportErrorLog(ErrorFileParamInfo object, IReportResultCallback iReportResultCallback) {
        try {
            a.a();
            object = a.a((ErrorFileParamInfo)object);
            Trace.d((String)TAG, (String)("reportErrorLog(): " + (String)object));
            if (TextUtils.isEmpty((CharSequence)object)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (com.abupdate.iot_libs.utils.d.a((String)object)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
        catch (FotaException fotaException) {
            iReportResultCallback.onReportFail();
            fotaException.printStackTrace();
            return;
        }
    }

    public void reportDown(DownParamInfo object, IReportResultCallback iReportResultCallback) {
        try {
            a.a();
            object = a.a((DownParamInfo)object);
            if (TextUtils.isEmpty((CharSequence)object)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (com.abupdate.iot_libs.utils.d.a((String)object)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
    }

    public void reportUpgrade(UpgradeParamInfo object, IReportResultCallback iReportResultCallback) {
        try {
            a.a();
            object = a.a((UpgradeParamInfo)object);
            if (TextUtils.isEmpty((CharSequence)object)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (com.abupdate.iot_libs.utils.d.a((String)object)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
    }

    public void reportPushData(PushMessageInfo object, IReportResultCallback iReportResultCallback) {
        try {
            a.a();
            object = a.a(((PushMessageInfo)object).msgId);
            if (TextUtils.isEmpty((CharSequence)object)) {
                iReportResultCallback.onReportNetFail();
                return;
            }
            if (com.abupdate.iot_libs.utils.d.a((String)object)) {
                iReportResultCallback.onReportSuccess();
                return;
            }
            iReportResultCallback.onReportFail();
            return;
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ String access$000() {
        return TAG;
    }

    static /* synthetic */ b access$100(ReportManager reportManager) {
        return reportManager.m_dbManager;
    }
}

