/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.abupdate.iot_libs.MqttAgentPolicy;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.engine.LogManager;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.UpgradeParamInfo;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.f;
import com.abupdate.trace.Trace;
import java.io.File;

public class UpgradeReceiver
extends BroadcastReceiver {
    private Context a;

    public void onReceive(Context object, Intent object2) {
        this.a = object;
        if (OtaAgentPolicy.sCx == null) {
            SPFTool.initContext(this.a);
        }
        object = object2.getAction();
        Trace.d((String)"UpgradeReceiver", (String)("action: " + (String)object));
        object2 = object;
        object = this;
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(object2)) {
            if (Build.VERSION.SDK_INT < 21 && f.a()) {
                Trace.d((String)"UpgradeReceiver", (String)("network_process() should_report = " + SPFTool.getBoolean("key_should_report", false)));
                if (SPFTool.getBoolean("key_should_report", false)) {
                    super.a();
                }
                if (System.currentTimeMillis() - SPFTool.getLong("spf_static_check_version_cycle", -1L) >= 259200000L) {
                    OtaService.startByAction("action_static_check_version");
                    SPFTool.putLong("spf_static_check_version_cycle", System.currentTimeMillis());
                }
                if (SPFTool.getBoolean("config_mqtt_connect", false) && !MqttAgentPolicy.isConnected()) {
                    MqttAgentPolicy.connect();
                }
            }
            return;
        }
        if ("android.intent.action.BOOT_COMPLETED".equals(object2)) {
            SPFTool.putBoolean("key_should_report", true);
            object2 = SPFTool.getString("key_version_name", "");
            String string = SPFTool.getString("KEY_DELTAID", "");
            if (!TextUtils.isEmpty((CharSequence)object2) && !TextUtils.isEmpty((CharSequence)string)) {
                SPFTool.putString("key_version_name", "");
                SPFTool.putString("KEY_DELTAID", "");
                Trace.i((String)"UpgradeReceiver", (String)("mobile version:" + DeviceInfo.getInstance().version + " update version " + (String)object2));
                boolean bl = ((String)object2).equals(DeviceInfo.getInstance().version);
                Object object3 = new Intent("action_fota_update_result");
                object3.putExtra("key_fota_update_result", bl);
                ((UpgradeReceiver)((Object)object)).a.sendBroadcast(object3, "permission.com.abupdate.fota.update");
                if (bl) {
                    Trace.d((String)"UpgradeReceiver", (String)"boot_process() update success!");
                    object3 = SPFTool.getString("key_update_file_path", "");
                    if (!TextUtils.isEmpty((CharSequence)object3)) {
                        new File((String)object3).delete();
                    }
                } else {
                    Trace.d((String)"UpgradeReceiver", (String)"boot_process() update failed!");
                }
                object3 = TextUtils.isEmpty((CharSequence)DeviceInfo.getInstance().mid) ? SPFTool.getString("key_mid_back", "abupdate-MID-ERROR-COLLECT") : DeviceInfo.getInstance().mid;
                object3 = new UpgradeParamInfo((String)object3, string, String.valueOf(bl ? 1 : 99));
                ReportManager.getInstance(((UpgradeReceiver)((Object)object)).a).saveReportData(object3);
                if (!bl) {
                    LogManager.getInstance().saveRecoveryLog(string);
                }
                if (f.a(OtaAgentPolicy.sCx) || f.a()) {
                    Trace.d((String)"UpgradeReceiver", (String)"boot_process() boot complete upgrade report");
                    super.a();
                }
            }
        }
    }

    private void a() {
        if (ReportManager.getInstance(this.a).queryReport() == 0) {
            SPFTool.putBoolean("key_should_report", false);
            Trace.d((String)"UpgradeReceiver", (String)"report() do not have data to be reported!");
            return;
        }
        OtaService.startByAction("action_report");
    }
}

