/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.policy;

import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.StatFs;
import android.util.Pair;
import com.abupdate.iot_libs.constant.OtaConstants;
import com.abupdate.iot_libs.engine.p;
import com.abupdate.iot_libs.info.PolicyMapInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IParsePolicyListener;
import com.abupdate.iot_libs.policy.PolicyConfig;
import com.abupdate.iot_libs.utils.c;
import com.abupdate.iot_libs.utils.j;
import com.abupdate.trace.Trace;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public class PolicyManager {
    private static final String TAG = "PolicyManager";
    public static PolicyManager INSTANCE = new PolicyManager();

    private PolicyManager() {
    }

    public boolean is_request_wifi() {
        if (!PolicyConfig.getInstance().wifi) {
            return false;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_wifi");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("download_wifi");
        if (object != null) {
            if ("required".equals(((PolicyMapInfo)object).key_value)) {
                return true;
            }
            Trace.d((String)TAG, (String)"is_request_wifi()");
        }
        return false;
    }

    public boolean is_storage_space_enough(String string) {
        if (!PolicyConfig.getInstance().storage_size) {
            return true;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_storageSize");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("download_storageSize");
        if (object != null) {
            try {
                long l2;
                long l3;
                p.a();
                String string2 = string;
                String string3 = new File(string2).getParentFile().getAbsolutePath();
                if (!c.a(string3)) {
                    throw new IllegalArgumentException("Invalid path:" + string2);
                }
                string2 = new StatFs(string3);
                if (Build.VERSION.SDK_INT >= 18) {
                    l3 = string2.getBlockSizeLong();
                    l2 = string2.getAvailableBlocksLong();
                } else {
                    l3 = string2.getBlockSize();
                    l2 = string2.getBlockCount();
                }
                long l4 = l3 * l2;
                Trace.i((String)TAG, (String)String.format("is_storage_space_enough() need_size = %s,free_size = %s,path = %s", ((PolicyMapInfo)object).key_value, l4, string));
                return Long.parseLong(((PolicyMapInfo)object).key_value) <= l4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }
        return true;
    }

    public String get_storage_path() {
        if (!PolicyConfig.getInstance().storage_path) {
            return null;
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("download_storagePath");
        if (policyMapInfo != null) {
            return policyMapInfo.key_value;
        }
        return null;
    }

    public boolean is_battery_enough(Context context) {
        if (!PolicyConfig.getInstance().battery) {
            return true;
        }
        Object object = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_battery");
        if (object != null) {
            return object.doParse();
        }
        object = VersionInfo.getInstance().policyHashMap.get("install_battery");
        if (object != null) {
            p.a();
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            int n2 = context.registerReceiver(null, intentFilter).getIntExtra("level", -1);
            Trace.d((String)TAG, (String)("batteryLevel mobile = " + n2 + "  config = " + ((PolicyMapInfo)object).key_value));
            try {
                return n2 >= Integer.parseInt(((PolicyMapInfo)object).key_value);
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return true;
    }

    public boolean is_force_install() {
        if (!PolicyConfig.getInstance().install_force) {
            return false;
        }
        Pair<Date, Date> pair = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_force");
        if (pair != null) {
            return pair.doParse();
        }
        pair = this.getForceInstallTime();
        if (pair != null) {
            StringBuilder stringBuilder = new StringBuilder();
            p.a();
            StringBuilder stringBuilder2 = stringBuilder.append(p.b().get(11)).append(":");
            p.a();
            if (j.a(stringBuilder2.append(p.b().get(12)).toString(), (Date)pair.first, (Date)pair.second)) {
                return true;
            }
        }
        return false;
    }

    public int get_check_cycle() {
        PolicyMapInfo policyMapInfo;
        if (!PolicyConfig.getInstance().check_cycle) {
            return -1;
        }
        try {
            policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_cycle");
        }
        catch (Exception exception) {
            return -1;
        }
        if (policyMapInfo != null) {
            try {
                int n2 = Integer.parseInt(policyMapInfo.key_value);
                if (n2 > 60) {
                    return n2;
                }
                return 60;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public int get_remind_cycle() {
        PolicyMapInfo policyMapInfo;
        if (!PolicyConfig.getInstance().remind_cycle) {
            return -1;
        }
        try {
            policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_remind");
        }
        catch (Exception exception) {
            return -1;
        }
        if (policyMapInfo != null) {
            try {
                int n2 = Integer.parseInt(policyMapInfo.key_value);
                if (n2 > 60) {
                    return n2;
                }
                return 60;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public boolean isDownloadForce() {
        if (!PolicyConfig.getInstance().download_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_forceDownload");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("download_forceDownload");
    }

    public boolean isRebootUpdateForce() {
        if (!PolicyConfig.getInstance().reboot_update_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_rebootUpgrade");
        if (iParsePolicyListener != null) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("install_rebootUpgrade");
    }

    public boolean isGetToInstallFreeTime() {
        if (!PolicyConfig.getInstance().install_free_time) {
            return false;
        }
        Pair<Date, Date> pair = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_freeInstall");
        if (pair != null) {
            return pair.doParse();
        }
        pair = this.getInstallFreeTime();
        if (pair != null) {
            StringBuilder stringBuilder = new StringBuilder();
            p.a();
            StringBuilder stringBuilder2 = stringBuilder.append(p.b().get(11)).append(":");
            p.a();
            if (j.a(stringBuilder2.append(p.b().get(12)).toString(), (Date)pair.first, (Date)pair.second)) {
                return true;
            }
        }
        return false;
    }

    public Pair<Date, Date> getInstallFreeTime() {
        if (!PolicyConfig.getInstance().install_free_time) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_free_time);
    }

    public Pair<Date, Date> getForceInstallTime() {
        if (!PolicyConfig.getInstance().install_force) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_force);
    }

    public Pair<Date, Date> getTimeInterval(OtaConstants.IntervalTimePolicy object) {
        if ((object = VersionInfo.getInstance().policyHashMap.get(((OtaConstants.IntervalTimePolicy)((Object)object)).getType())) != null) {
            try {
                object = new JSONObject(((PolicyMapInfo)object).key_value);
                Object object2 = object.getString("from");
                object = object.getString("to");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                object2 = simpleDateFormat.parse((String)object2);
                object = simpleDateFormat.parse((String)object);
                if (((Date)object2).getTime() != ((Date)object).getTime()) {
                    return new Pair(object2, object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private boolean getInfoByKey(String object) {
        try {
            object = VersionInfo.getInstance().policyHashMap.get(object);
        }
        catch (Exception exception) {
            return false;
        }
        return object != null && "true".equals(((PolicyMapInfo)object).key_value);
    }

    public String displayPolicy() {
        StringBuilder stringBuilder = new StringBuilder();
        if (VersionInfo.getInstance().policyHashMap != null) {
            for (Map.Entry<String, PolicyMapInfo> entry : VersionInfo.getInstance().policyHashMap.entrySet()) {
                stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }
}

