/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.inter;

import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.engine.n;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.info.RegisterInfo;
import com.abupdate.iot_libs.inter.IListener;
import com.abupdate.iot_libs.inter.ILoginCallback;
import com.abupdate.iot_libs.inter.IStatusListener;
import com.abupdate.iot_libs.inter.MessageListener;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.IMqttActionListener;
import com.abupdate.mqtt_libs.mqttv3.IMqttToken;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OtaListener
implements MessageListener.ConnectionLostListener,
IMqttActionListener {
    private static final String TAG = "OtaListener";
    private static OtaListener mInstance;
    Object mLock = new Object();
    List<Action> subAction = new ArrayList<Action>();
    Action[] allSubAction = new Action[]{Action.SUB_LOGIN, Action.SUB_LOGOUT, Action.SUB_NOTIFY};
    private int reSubCount = 3;
    private Action action;
    private Map<Enum, List<IListener>> listeners = new HashMap<Enum, List<IListener>>();

    @Override
    public void onConnectLost(int n2) {
        Iterator<IListener> iterator = this.getListener(Action.CONNECT);
        if (-1 == n2) {
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    ((IStatusListener)iterator.next()).onDisconnected();
                }
            }
        } else {
            if (iterator != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    ((IStatusListener)iterator.next()).onAbnormalDisconnected(n2);
                }
            }
            if (5 != n2 && 4 != n2) {
                MqttManager.getInstance().keepConnect(1800000L, System.currentTimeMillis() + 30000L);
            }
        }
        this.setAction(Action.CONNECT);
        b.a().a(b.a.g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OtaListener getInstance() {
        if (mInstance != null) return mInstance;
        Class<OtaListener> clazz = OtaListener.class;
        synchronized (OtaListener.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OtaListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public OtaListener setAction(Action action) {
        this.action = action;
        if (Action.CONNECT == action) {
            MessageListener.getInstance().setConnectionLostListener(this);
        }
        return this;
    }

    private OtaListener() {
    }

    public void addListener(Action action, IListener iListener) {
        if (!this.listeners.containsKey((Object)action)) {
            this.listeners.put(action, new ArrayList());
        }
        this.listeners.get((Object)action).add(iListener);
    }

    public void removeAllListener(Action action) {
        if (this.listeners.containsKey((Object)action)) {
            this.listeners.get((Object)action).clear();
        }
    }

    public boolean removeListener(Action action, IListener iListener) {
        if (this.listeners.containsKey((Object)action)) {
            return this.listeners.get((Object)action).remove(iListener);
        }
        return false;
    }

    public void onSuccess(IMqttToken iMqttToken) {
        switch (this.action) {
            case CONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket connect success");
                this.connect();
                return;
            }
            case DISCONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket disconnect success");
                this.disConnect();
                return;
            }
            case PUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onSuccess() pub report deviceinfo");
                return;
            }
            case PUB_LOGIN: {
                Trace.d((String)TAG, (String)"onSuccess() pub login");
                return;
            }
            case PUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onSuccess() pub logout");
                return;
            }
            case SUB_LOGIN: {
                this.lockNotify();
                this.addSubAction(Action.SUB_LOGIN);
                return;
            }
            case SUB_LOGOUT: {
                this.lockNotify();
                this.addSubAction(Action.SUB_LOGOUT);
                return;
            }
            case SUB_NOTIFY: {
                this.lockNotify();
                this.addSubAction(Action.SUB_NOTIFY);
                return;
            }
            case SUB_REPORT_DEVICEINFO: {
                this.lockNotify();
            }
        }
    }

    private void disConnect() {
    }

    private void connect() {
        b.a().a(b.a.c);
        List<IListener> list = this.getListener(Action.CONNECT);
        this.doLogin(list);
    }

    private void doLogin(final List<IListener> list) {
        n.a().a(new Runnable(){

            @Override
            public void run() {
                OtaListener.this.subTask();
                if (OtaListener.this.subAction.size() == OtaListener.this.allSubAction.length) {
                    Object object = new ILoginCallback(){

                        @Override
                        public void onLoginSuccess() {
                            if (list != null) {
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    ((IStatusListener)((IListener)iterator.next())).onConnected();
                                }
                            }
                        }

                        @Override
                        public void onLoginFail(int n2) {
                            OtaService.selfDisconnect();
                        }

                        @Override
                        public void onLoginTimeout() {
                            OtaService.selfDisconnect();
                        }
                    };
                    b b2 = b.a();
                    Trace.d((String)"OtaTools", (String)"login() start");
                    if (!DeviceInfo.getInstance().isValid()) {
                        Trace.e((String)"OtaTools", (String)"login() device info is null");
                        return;
                    }
                    b2.a((ILoginCallback)object);
                    object = String.format("product/%s/%s/login", ProductInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
                    JSONObject jSONObject = new JSONObject();
                    JSONObject jSONObject2 = new JSONObject();
                    String string = String.valueOf(System.currentTimeMillis() / 1000L);
                    String string2 = b.d();
                    try {
                        jSONObject.put("timestamp", (Object)string);
                        jSONObject.put("sign", (Object)(ProductInfo.getInstance().productId + string));
                        jSONObject2.put("body", (Object)jSONObject);
                        jSONObject2.put("seqno", (Object)string2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    b.a((String)object, jSONObject2.toString(), OtaListener.getInstance().setAction(Action.PUB_LOGIN));
                    b2.a.put(1000, string2);
                    return;
                }
                OtaService.selfDisconnect();
            }
        });
    }

    private List<IListener> getListener(Action action) {
        return this.listeners.get((Object)action);
    }

    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
        switch (this.action) {
            case CONNECT: {
                Trace.d((String)TAG, (String)"onFailure() connect");
                this.connect(throwable);
                return;
            }
            case DISCONNECT: {
                Trace.d((String)TAG, (String)"onFailure() disconnect");
                this.disconnect(throwable);
                return;
            }
            case PUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onFailure() pub report deviceinfo");
                return;
            }
            case PUB_LOGIN: {
                Trace.d((String)TAG, (String)"onFailure() pub login");
                return;
            }
            case PUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onFailure() pub logout");
                return;
            }
            case SUB_LOGIN: {
                Trace.d((String)TAG, (String)"onFailure() sub login");
                this.lockNotify();
                return;
            }
            case SUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onFailure() sub logout");
                this.lockNotify();
                return;
            }
            case SUB_NOTIFY: {
                Trace.d((String)TAG, (String)"onFailure() sub notify");
                this.lockNotify();
                return;
            }
            case SUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onFailure() sub report deviceinfo");
                this.lockNotify();
            }
        }
    }

    public void disconnect(Throwable throwable) {
        b.a().a(b.a.g);
        Object object = this.getListener(Action.CONNECT);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((IStatusListener)((IListener)object.next())).onError(this.getError(throwable));
            }
        }
        if (throwable == null) {
            return;
        }
        Trace.e((String)TAG, (String)("disconnect() exception:" + throwable.toString()));
        throwable.printStackTrace();
    }

    public void connect(Throwable throwable) {
        b.a().a(b.a.g);
        Object object = this.getListener(Action.CONNECT);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((IStatusListener)((IListener)object.next())).onError(this.getError(throwable));
            }
        }
        if (throwable != null) {
            throwable.printStackTrace();
            Trace.e((String)TAG, (String)("connect() " + throwable.toString()));
        }
        if (MqttManager.getInstance().isConneect() || b.a().b() == b.a.b) {
            return;
        }
        if (5 != this.getError(throwable) && 4 != this.getError(throwable)) {
            MqttManager.getInstance().keepConnect(1800000L, System.currentTimeMillis() + 30000L);
        }
    }

    private int getError(Throwable throwable) {
        if (throwable instanceof MqttException) {
            return ((MqttException)throwable).getReasonCode();
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockNotify() {
        if (this.mLock != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notify();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadLock() {
        if (this.mLock != null) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                return;
            }
        }
    }

    private void addSubAction(Action action) {
        if (this.subAction == null) {
            return;
        }
        if (!this.subAction.contains((Object)action)) {
            this.subAction.add(action);
        }
    }

    private void subTask() {
        while (this.reSubCount > 0 && this.subAction.size() < this.allSubAction.length) {
            --this.reSubCount;
            if (this.allSubAction == null || this.allSubAction.length == 0) {
                return;
            }
            for (int i2 = 0; i2 < this.allSubAction.length; ++i2) {
                if (this.subAction.contains((Object)this.allSubAction[i2])) continue;
                if (this.allSubAction[i2] == Action.SUB_LOGIN) {
                    b.a();
                    b.a(String.format("product/%s/%s/login/response", ProductInfo.getInstance().productId, RegisterInfo.getInstance().deviceId), OtaListener.getInstance().setAction(Action.SUB_LOGIN));
                    this.threadLock();
                    continue;
                }
                if (this.allSubAction[i2] == Action.SUB_LOGOUT) {
                    b.a();
                    b.a(String.format("product/%s/%s/logout/response", ProductInfo.getInstance().productId, RegisterInfo.getInstance().deviceId), OtaListener.getInstance().setAction(Action.SUB_LOGOUT));
                    this.threadLock();
                    continue;
                }
                if (this.allSubAction[i2] != Action.SUB_NOTIFY) continue;
                b.a();
                b.a(String.format("product/%s/%s/notify", ProductInfo.getInstance().productId, RegisterInfo.getInstance().deviceId), OtaListener.getInstance().setAction(Action.SUB_NOTIFY));
                this.threadLock();
            }
        }
        this.reSubCount = 3;
    }

    public static enum Action {
        CONNECT,
        DISCONNECT,
        PUB_REPORT_DEVICEINFO,
        PUB_LOGIN,
        PUB_LOGOUT,
        SUB_LOGIN,
        SUB_LOGOUT,
        SUB_NOTIFY,
        SUB_REPORT_DEVICEINFO;

    }
}

