/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.inter;

import android.content.Context;
import android.content.Intent;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.a.b;
import com.abupdate.iot_libs.info.PushMessageInfo;
import com.abupdate.iot_libs.inter.ILoginCallback;
import com.abupdate.iot_libs.inter.ILogoutCallback;
import com.abupdate.iot_libs.inter.IReportDeviceStatusCallback;
import com.abupdate.iot_libs.inter.TimeoutCallback;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.d;
import com.abupdate.iot_libs.utils.h;
import com.abupdate.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.abupdate.mqtt_libs.mqttv3.MqttCallback;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.mqtt_libs.mqttv3.MqttMessage;
import com.abupdate.trace.Trace;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageListener
implements MqttCallback {
    private static final String TAG = "MessageListener";
    private static final String LOGOUT_RESPONSE = "logout/response";
    private static final String LOGIN_RESPONSE = "login/response";
    private static final String REPORT_DEVICE_STATUS_RESPONSE = "update/response";
    private static final String PUSH_NOTIFY = "notify";
    public static final int DISCONNECTED_OK = -1;
    private Context mCx;
    private ILoginCallback mILoginCallback;
    private ILogoutCallback mILogoutCallback;
    private IReportDeviceStatusCallback mIReportDeviceStatusCallback;
    private static final int RESPONSE_TIMEOUT = 5000;
    private boolean timeout = true;
    private static MessageListener messageListener;
    private ConnectionLostListener mConnectionLostListener;
    private State currentState = State.Null;

    private MessageListener() {
        this.mCx = OtaAgentPolicy.sCx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageListener getInstance() {
        if (messageListener != null) return messageListener;
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            if (messageListener != null) return messageListener;
            messageListener = new MessageListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return messageListener;
        }
    }

    public void connectionLost(Throwable throwable) {
        Trace.d((String)TAG, (String)"connectionLost() ");
        if (this.mConnectionLostListener != null) {
            int n2 = throwable != null && throwable instanceof MqttException ? ((MqttException)throwable).getReasonCode() : (throwable == null ? -1 : 6);
            this.mConnectionLostListener.onConnectLost(n2);
        }
    }

    public void messageArrived(String string, MqttMessage object) throws Exception {
        object = new String(object.getPayload());
        Trace.d((String)TAG, (String)("messageArrived() :" + string));
        Trace.d((String)TAG, (String)("messageArrived() :" + (String)object));
        if (this.currentState == State.Null && !string.endsWith(PUSH_NOTIFY)) {
            Trace.d((String)TAG, (String)"messageArrived() state is null");
            return;
        }
        if (string.endsWith(LOGIN_RESPONSE)) {
            string = this.getReply((String)object);
            if (b.a().a(1000, string)) {
                this.timeout = false;
                int n2 = d.c((String)object);
                if (d.b(n2)) {
                    Trace.d((String)TAG, (String)"messageArrived() login response success!");
                    this.mILoginCallback.onLoginSuccess();
                    b.a().a(b.a.d);
                    return;
                }
                Trace.d((String)TAG, (String)"messageArrived() login response failed!");
                this.mILoginCallback.onLoginFail(n2);
            }
            return;
        }
        if (string.endsWith(LOGOUT_RESPONSE)) {
            string = this.getReply((String)object);
            if (b.a().a(1001, string)) {
                Trace.d((String)TAG, (String)"messageArrived() logout response success!");
                this.timeout = false;
                int n3 = d.c((String)object);
                if (d.b(n3)) {
                    this.mILogoutCallback.onLogoutSuccess();
                    b.a().a(b.a.e);
                    return;
                }
                this.mILogoutCallback.onLogoutFail(n3);
            }
            return;
        }
        if (string.endsWith(REPORT_DEVICE_STATUS_RESPONSE)) {
            string = this.getReply((String)object);
            if (b.a().a(1002, string)) {
                Trace.d((String)TAG, (String)"messageArrived() report device info success");
                this.timeout = false;
                int n4 = d.c((String)object);
                if (d.b(n4)) {
                    this.mIReportDeviceStatusCallback.onReportSuccess();
                    return;
                }
                this.mIReportDeviceStatusCallback.onReportFail(n4);
            }
            return;
        }
        if (string.endsWith(PUSH_NOTIFY) && (string = new JSONObject((String)object)).has("body")) {
            if ((string = string.getJSONObject("body")).has("content")) {
                object = string.getString("content");
                Intent intent = new Intent();
                intent.setAction("action_fota_notify");
                intent.putExtra("key_fota_notify", (String)object);
                this.mCx.sendBroadcast(intent, "permission.com.abupdate.fota.update");
            }
            if (string.has("msgId")) {
                object = string.getString("msgId");
                ReportManager.getInstance(this.mCx).savePushResponseData(new PushMessageInfo((String)object));
                OtaService.startByAction("action_report");
            }
        }
    }

    private String getReply(String string) {
        try {
            string = new JSONObject(string);
            if (string.has("replyno")) {
                return string.getString("replyno");
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return "";
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void setLoginListener(ILoginCallback iLoginCallback) {
        this.mILoginCallback = iLoginCallback;
        this.setCurrentState(State.Login);
        this.timeStart();
    }

    public void setLogoutListener(ILogoutCallback iLogoutCallback) {
        this.mILogoutCallback = iLogoutCallback;
        this.setCurrentState(State.Logout);
        this.timeStart();
    }

    public void setReportDeviceStatusListener(IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        this.mIReportDeviceStatusCallback = iReportDeviceStatusCallback;
        this.setCurrentState(State.ReportDeviceInfo);
        this.timeStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStart() {
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            h.a().a(new TimeoutCallback(){

                @Override
                public void onTimeout() {
                    if (MessageListener.this.timeout) {
                        if (MessageListener.this.currentState == State.Login) {
                            MessageListener.this.mILoginCallback.onLoginTimeout();
                        }
                        if (MessageListener.this.currentState == State.Logout) {
                            MessageListener.this.mILogoutCallback.onLogoutTimeout();
                        }
                        if (MessageListener.this.currentState == State.ReportDeviceInfo) {
                            MessageListener.this.mIReportDeviceStatusCallback.onReportFail(32000);
                        }
                        MessageListener.this.setCurrentState(State.Null);
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setCurrentState(State state) {
        this.timeout = true;
        this.currentState = state;
    }

    public void setConnectionLostListener(ConnectionLostListener connectionLostListener) {
        this.mConnectionLostListener = connectionLostListener;
    }

    public static interface ConnectionLostListener {
        public void onConnectLost(int var1);
    }

    static enum State {
        Null,
        Login,
        Logout,
        ReportDeviceInfo;

    }
}

