/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.info;

import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.info.RegisterInfo;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    public static final String KEY_MID_BACK = "key_mid_back";
    public String mid;
    public String version;
    public String oem;
    public String models;
    public String platform;
    public String deviceType;
    public static DeviceInfo mInstance;
    private static final String KEY_DEVICE_INFO = "key_device_info";

    private DeviceInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<DeviceInfo> clazz = DeviceInfo.class;
        synchronized (DeviceInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DeviceInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init() throws FotaException {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init info", "--------------------------"});
        try {
            Class<?> clazz = OtaAgentPolicy.sCx.getClassLoader().loadClass("android.os.SystemProperties");
            Class[] classArray = new Class[1];
            Object object = classArray;
            classArray[0] = String.class;
            object = clazz.getMethod("get", (Class<?>)object);
            this.version = (String)((Method)object).invoke(clazz, "ro.fota.version");
            this.oem = (String)((Method)object).invoke(clazz, "ro.fota.oem");
            this.models = (String)((Method)object).invoke(clazz, "ro.fota.device");
            this.platform = (String)((Method)object).invoke(clazz, "ro.fota.platform");
            this.deviceType = (String)((Method)object).invoke(clazz, "ro.fota.type");
        }
        catch (Exception exception) {
            throw new FotaException(202, (Throwable)exception);
        }
        finally {
            if (!this.compareProduct()) {
                ProductInfo.getInstance().reset();
                RegisterInfo.getInstance().reset();
            }
        }
        Trace.d((String)TAG, (String)String.format("version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", this.version, this.oem, this.models, this.platform, this.deviceType));
    }

    public void initInfo(String string) {
        Trace.d((String)TAG, (String)("set mid:" + string));
        this.mid = string;
        SPFTool.putString(KEY_MID_BACK, string);
    }

    public void initOtherInfo(String string, String string2, String string3, String string4, String string5) throws FotaException {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init other info", "--------------------------"});
        this.oem = string2;
        this.models = string3;
        this.platform = string4;
        this.deviceType = string5;
        this.version = string;
        if (!this.compareProduct()) {
            ProductInfo.getInstance().reset();
            RegisterInfo.getInstance().reset();
        }
        Trace.d((String)TAG, (String)String.format("version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", string, string2, string3, string4, string5));
    }

    public boolean isValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.mid)) {
            Trace.d((String)TAG, (String)"isValid() mid = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.oem)) {
            Trace.d((String)TAG, (String)"isValid() oem = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.models)) {
            Trace.d((String)TAG, (String)"isValid() models = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.platform)) {
            Trace.d((String)TAG, (String)"isValid() platform = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceType)) {
            Trace.d((String)TAG, (String)"isValid() deviceType = null");
            bl = false;
        }
        return bl;
    }

    private boolean compareProduct() {
        String string;
        String string2 = SPFTool.getString(KEY_DEVICE_INFO, "");
        if (TextUtils.equals((CharSequence)string2, (CharSequence)(string = DeviceInfo.getInstance().oem + DeviceInfo.getInstance().models + DeviceInfo.getInstance().platform + DeviceInfo.getInstance().deviceType))) {
            return true;
        }
        SPFTool.putString(KEY_DEVICE_INFO, string);
        return false;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("mid", (Object)this.mid);
            jSONObject.put("version", (Object)this.version);
            jSONObject.put("oem", (Object)this.oem);
            jSONObject.put("models", (Object)this.models);
            jSONObject.put("platform", (Object)this.platform);
            jSONObject.put("deviceType", (Object)this.deviceType);
            jSONObject.put("productId", (Object)ProductInfo.getInstance().productId);
            jSONObject.put("productSecret", (Object)ProductInfo.getInstance().productSecret);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }
}

