/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import android.content.Context;
import com.abupdate.iot_libs.info.CustomDeviceInfo;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.a;
import com.abupdate.trace.Trace;
import org.json.JSONObject;

public class IndirectOtaAgentPolicy {
    private static final String TAG = "IndirectOtaAgentPolicy";

    public static String getDeviceInfo() {
        Trace.d((String)TAG, (String)"getDeviceInfo() ");
        return DeviceInfo.getInstance().toString();
    }

    public static CustomDeviceInfo setDeviceInfo(String string) {
        Trace.d((String)TAG, (String)("setDeviceInfo() device info:" + string));
        CustomDeviceInfo customDeviceInfo = new CustomDeviceInfo();
        try {
            string = new JSONObject(string);
            customDeviceInfo.mid = string.getString("mid");
            customDeviceInfo.version = string.getString("version");
            customDeviceInfo.oem = string.getString("oem");
            customDeviceInfo.models = string.getString("models");
            customDeviceInfo.platform = string.getString("platform");
            customDeviceInfo.deviceType = string.getString("deviceType");
            customDeviceInfo.productId = string.getString("productId");
            customDeviceInfo.product_secret = string.getString("productSecret");
        }
        catch (Exception exception) {
            Trace.e((String)TAG, (Throwable)exception);
        }
        return customDeviceInfo;
    }

    public static boolean resetDeviceInfo(String string) {
        Trace.d((String)TAG, (String)("resetDeviceInfo() device info:" + string));
        try {
            string = new JSONObject(string);
            DeviceInfo.getInstance().mid = string.getString("mid");
            DeviceInfo.getInstance().version = string.getString("version");
            DeviceInfo.getInstance().oem = string.getString("oem");
            DeviceInfo.getInstance().models = string.getString("models");
            DeviceInfo.getInstance().platform = string.getString("platform");
            DeviceInfo.getInstance().deviceType = string.getString("deviceType");
            ProductInfo.getInstance().productId = string.getString("productId");
            ProductInfo.getInstance().productSecret = string.getString("productSecret");
        }
        catch (Exception exception) {
            Trace.e((String)TAG, (Throwable)exception);
        }
        return DeviceInfo.getInstance().isValid();
    }

    public static String getVersionInfo() {
        Trace.d((String)TAG, (String)"getVersionInfo() ");
        return SPFTool.getString("key_version_info", "");
    }

    public static void setVersionInfo(String string) {
        Trace.d((String)TAG, (String)("setVersionInfo() version info:" + string));
        a.a(string);
    }

    public static void reportUpdate(Context context, boolean bl) {
        Trace.d((String)TAG, (String)("reportUpdate() result:" + bl));
        ReportManager.getInstance(context).reportUpdateParamInfo(bl ? 1 : 99);
    }
}

