/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.policy;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.StatFs;
import android.util.Pair;
import com.abupdate.iot_libs.constant.OtaConstants;
import com.abupdate.iot_libs.info.PolicyMapInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IParsePolicyListener;
import com.abupdate.iot_libs.policy.PolicyConfig;
import com.abupdate.iot_libs.utils.c;
import com.abupdate.iot_libs.utils.i;
import com.abupdate.trace.Trace;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public class PolicyManager {
    private static final String TAG = "PolicyManager";
    public static PolicyManager INSTANCE = new PolicyManager();

    private PolicyManager() {
    }

    public boolean is_request_wifi() {
        if (!PolicyConfig.getInstance().wifi) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_wifi");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("download_wifi");
        if (policyMapInfo != null) {
            if ("required".equals(policyMapInfo.key_value)) {
                return true;
            }
            Trace.d((String)TAG, (String)"is_request_wifi()");
        }
        return false;
    }

    public boolean is_storage_space_enough(String string2) {
        if (!PolicyConfig.getInstance().storage_size) {
            return true;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_storageSize");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("download_storageSize");
        if (policyMapInfo != null) {
            try {
                long l = this.getStorageSpace(string2);
                Trace.i((String)TAG, (String)String.format("is_storage_space_enough() need_size = %s,free_size = %s,path = %s", policyMapInfo.key_value, l, string2));
                return Long.parseLong(policyMapInfo.key_value) <= l;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }
        return true;
    }

    public String get_storage_path() {
        if (!PolicyConfig.getInstance().storage_path) {
            return null;
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("download_storagePath");
        if (policyMapInfo != null) {
            return policyMapInfo.key_value;
        }
        return null;
    }

    public boolean is_battery_enough(Context context) {
        if (!PolicyConfig.getInstance().battery) {
            return true;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_battery");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get("install_battery");
        if (policyMapInfo != null) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            int n = intent.getIntExtra("level", -1);
            Trace.d((String)TAG, (String)("batteryLevel mobile = " + n + "  config = " + policyMapInfo.key_value));
            try {
                return n >= Integer.parseInt(policyMapInfo.key_value);
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return true;
    }

    public boolean is_force_install() {
        SimpleDateFormat simpleDateFormat;
        String string2;
        if (!PolicyConfig.getInstance().install_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_force");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        Pair<Date, Date> pair = this.getForceInstallTime();
        return null != pair && i.a(string2 = (simpleDateFormat = new SimpleDateFormat("HH:mm")).format(new Date()), (Date)pair.first, (Date)pair.second);
    }

    public int get_check_cycle() {
        if (!PolicyConfig.getInstance().check_cycle) {
            return -1;
        }
        PolicyMapInfo policyMapInfo = null;
        try {
            policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_cycle");
        }
        catch (Exception exception) {
            return -1;
        }
        if (policyMapInfo != null) {
            try {
                int n = Integer.parseInt(policyMapInfo.key_value);
                return n > 60 ? n : 60;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public int get_remind_cycle() {
        if (!PolicyConfig.getInstance().remind_cycle) {
            return -1;
        }
        PolicyMapInfo policyMapInfo = null;
        try {
            policyMapInfo = VersionInfo.getInstance().policyHashMap.get("check_remind");
        }
        catch (Exception exception) {
            return -1;
        }
        if (policyMapInfo != null) {
            try {
                int n = Integer.parseInt(policyMapInfo.key_value);
                return n > 60 ? n : 60;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -2;
            }
        }
        return -1;
    }

    public boolean isDownloadForce() {
        if (!PolicyConfig.getInstance().download_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("download_forceDownload");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("download_forceDownload");
    }

    public boolean isRebootUpdateForce() {
        if (!PolicyConfig.getInstance().reboot_update_force) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_rebootUpgrade");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        return this.getInfoByKey("install_rebootUpgrade");
    }

    public boolean isGetToInstallFreeTime() {
        SimpleDateFormat simpleDateFormat;
        String string2;
        if (!PolicyConfig.getInstance().install_free_time) {
            return false;
        }
        IParsePolicyListener iParsePolicyListener = PolicyConfig.getInstance().parsePolicyListenerMap.get("install_freeInstall");
        if (null != iParsePolicyListener) {
            return iParsePolicyListener.doParse();
        }
        Pair<Date, Date> pair = this.getInstallFreeTime();
        return null != pair && i.a(string2 = (simpleDateFormat = new SimpleDateFormat("HH:mm")).format(new Date()), (Date)pair.first, (Date)pair.second);
    }

    public Pair<Date, Date> getInstallFreeTime() {
        if (!PolicyConfig.getInstance().install_free_time) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_free_time);
    }

    public Pair<Date, Date> getForceInstallTime() {
        if (!PolicyConfig.getInstance().install_force) {
            return null;
        }
        return this.getTimeInterval(OtaConstants.IntervalTimePolicy.type_install_force);
    }

    public Pair<Date, Date> getTimeInterval(OtaConstants.IntervalTimePolicy intervalTimePolicy) {
        PolicyMapInfo policyMapInfo = VersionInfo.getInstance().policyHashMap.get(intervalTimePolicy.getType());
        if (null != policyMapInfo) {
            try {
                JSONObject jSONObject = new JSONObject(policyMapInfo.key_value);
                String string2 = jSONObject.getString("from");
                String string3 = jSONObject.getString("to");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                Date date = simpleDateFormat.parse(string2);
                Date date2 = simpleDateFormat.parse(string3);
                if (date.getTime() != date2.getTime()) {
                    return new Pair((Object)date, (Object)date2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private boolean getInfoByKey(String string2) {
        PolicyMapInfo policyMapInfo = null;
        try {
            policyMapInfo = VersionInfo.getInstance().policyHashMap.get(string2);
        }
        catch (Exception exception) {
            return false;
        }
        return null != policyMapInfo && "true".equals(policyMapInfo.key_value);
    }

    private long getStorageSpace(String string2) {
        Trace.d((String)TAG, (String)("getStorageSpace() [path] " + string2));
        File file = new File(string2);
        String string3 = file.getParentFile().getAbsolutePath();
        boolean bl = c.b(string3);
        if (!bl) {
            throw new IllegalArgumentException("Invalid path:" + string2);
        }
        StatFs statFs = new StatFs(string3);
        long l = 0L;
        long l2 = 0L;
        if (Build.VERSION.SDK_INT >= 18) {
            l = statFs.getBlockSizeLong();
            l2 = statFs.getAvailableBlocksLong();
        } else {
            l = statFs.getBlockSize();
            l2 = statFs.getBlockCount();
        }
        return l * l2;
    }

    public String displayPolicy() {
        StringBuilder stringBuilder = new StringBuilder();
        if (VersionInfo.getInstance().policyHashMap != null) {
            for (Map.Entry<String, PolicyMapInfo> entry : VersionInfo.getInstance().policyHashMap.entrySet()) {
                stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }
}

