package com.abupdate.iot_libs;

import com.abupdate.iot_libs.constant.OtaConstants;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.inter.IReportDeviceStatusCallback;
import com.abupdate.iot_libs.inter.IStatusListener;
import com.abupdate.iot_libs.inter.MessageListener;
import com.abupdate.iot_libs.inter.OtaListener;
import com.abupdate.iot_libs.interact.OtaTools;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.mqtt_libs.connect.MqttManager;
import com.abupdate.mqtt_libs.mqttv3.MqttException;
import com.abupdate.trace.Trace;

/**
 * Created by fighter_lee on 2017/5/23.
 */

public class MqttAgentPolicy {

    private static final String TAG = "MqttAgentPolicy";
    public static final String CONFIG_MQTT_CONNECT = "config_mqtt_connect";

    public static void initMqtt() {
        MqttManager.getInstance().setContext(OtaAgentPolicy.sCx);
        MqttManager.getInstance().registerMessageListener(MessageListener.getInstance());
        MqttManager.getInstance().setTraceEnable(false);
    }

    /**
     * 注册长连接状态回调
     * @param listener
     */
    public static void registerStatusListener(IStatusListener listener) {
        OtaListener.getInstance().addListener(OtaListener.Action.CONNECT, listener);
    }

    /**
     * 注销长连接状态回调
     * @param listener
     * @return
     */
    public static boolean unregisterStatusListener(IStatusListener listener) {
        return OtaListener.getInstance().removeListener(OtaListener.Action.CONNECT, listener);
    }

    /**
     * 断开长连接
     */
    public static void disConnect() {
        Trace.d(TAG, "%s%s%s", OtaConstants.SINGLE_LINE, "disconnect", OtaConstants.SINGLE_LINE);
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT,false);
        OtaService.selfDisconnect();
    }

    /**
     * 关闭断连重试机制
     */
    public static void stopKeepConnect() {
        Trace.d("MqttAgentPolicy", "stopKeepConnect() start.");
        if (MqttManager.getInstance().isKeepConnect()) {
            OtaService.startByAction(OtaService.ACTION_DISCONNECT);
        } else {
            Trace.d(TAG, "stopKeepConnect() is not config keep connect!");
        }
    }

    /**
     * 连接
     */
    public static void connect() {
        Trace.d(TAG, "%s%s%s", OtaConstants.SINGLE_LINE, "connect", OtaConstants.SINGLE_LINE);
        SPFTool.putBoolean(CONFIG_MQTT_CONNECT,true);
        if (MqttManager.getInstance().isConneect()) {
            Trace.d("MqttAgentPolicy", "connect() is connected");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connected")));
            return;
        }
        if (OtaTools.getInstance().getState() == OtaTools.State.Connecting) {
            Trace.d("MqttAgentPolicy", "connect() is connecting");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connecting")));
            return;
        }
        //参数条件
        if (!DeviceInfo.getInstance().isValid()){
            Trace.d(TAG, "connect() params is not valid");
            return;
        }
        OtaService.startByAction(OtaService.ACTION_CONNECT);
    }

    public static void reportDeviceStatus(String message, IReportDeviceStatusCallback callback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d("MqttAgentPolicy", "reportDeviceStatus() is disconnected");
            return;
        }
        if (OtaTools.getInstance().getState() != OtaTools.State.Login) {
            Trace.e("MqttAgentPolicy", "reportDeviceStatus() device is off line");
            return;
        }
        OtaTools.getInstance().reportDeviceInfo(message, callback);
    }

    /**
     * 是否在线
     * @return
     */
    public static boolean isConnected() {
        return MqttManager.getInstance().isConneect();
    }
}
