/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.engine;

import android.os.DropBoxManager;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ErrorFileParamInfo;
import com.abupdate.iot_libs.report.ReportManager;
import com.abupdate.iot_libs.report.b;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.c;
import com.abupdate.trace.Trace;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;

public class LogManager {
    private static final String TAG = "LogManager";
    private static LogManager mInstance;
    public static final int TASK_REPORT_RECOVERY_LOG = 1;
    public static final int TASK_REPORT_TRACE_LOG = 2;
    public static final String FILE_KEY = "uploadFile";
    String log_dir_s = OtaAgentPolicy.sCx.getFilesDir() + "/Log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new LogManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void report() {
        OtaService.startByAction("action_report");
    }

    public void saveTraceLog() {
        if (!OtaAgentPolicy.getConfig().reportLog) {
            return;
        }
        String string = OtaAgentPolicy.getConfig().tracePath;
        File file = this.zipTraceLog(string);
        if (null == file || !file.exists() || file.length() == 0L) {
            return;
        }
        this.saveTraceLog(file);
    }

    public void saveTraceLog(File file) {
        this.clearLog();
        ErrorFileParamInfo errorFileParamInfo = new ErrorFileParamInfo(DeviceInfo.getInstance().mid, String.valueOf(2), file.getAbsolutePath());
        ReportManager.getInstance(OtaAgentPolicy.sCx).saveErrorFileData(errorFileParamInfo);
        Trace.d((String)TAG, (String)"saveTraceLog() finish");
    }

    public void saveRecoveryLog(final String string) {
        if (!OtaAgentPolicy.getConfig().reportLog) {
            return;
        }
        this.clearLog();
        new Thread(new Runnable(){

            @Override
            public void run() {
                File file = LogManager.getInstance().zipRecoveryLog();
                if (null != file && file.exists() && file.length() > 0L) {
                    ErrorFileParamInfo errorFileParamInfo = new ErrorFileParamInfo(DeviceInfo.getInstance().mid, string, String.valueOf(1), file.getAbsolutePath());
                    ReportManager.getInstance(OtaAgentPolicy.sCx).saveErrorFileData(errorFileParamInfo);
                    Trace.d((String)LogManager.TAG, (String)"saveRecoveryLog() finish");
                }
            }
        }).start();
    }

    public File zipTraceLog(String string) {
        if (!new File(string).exists() || new File(string).length() <= 0L) {
            Trace.e((String)TAG, (String)"Trace file not exist!");
            return null;
        }
        String string2 = this.log_dir_s + File.separator + this.formatTime(System.currentTimeMillis()) + ".zip";
        if (!new File(this.log_dir_s).exists() && !c.b(this.log_dir_s)) {
            Trace.e((String)TAG, (String)"fota log dir create failed");
            return null;
        }
        try {
            if (c.a(new File(string), new File(string2))) {
                return new File(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public File zipRecoveryLog() {
        var1_1 = SPFTool.getLong("key_last_recovery_time", -1L);
        if (-1L == var1_1) {
            return null;
        }
        var3_2 = new File(this.log_dir_s);
        if (!var3_2.exists() && !c.b(this.log_dir_s)) {
            return null;
        }
        var4_3 = "";
        var5_4 = (DropBoxManager)OtaAgentPolicy.sCx.getSystemService("dropbox");
        var6_5 = var5_4.getNextEntry("SYSTEM_RECOVERY_LOG", var1_1);
        if (var6_5 != null && var5_4 != null && var5_4.isTagEnabled("SYSTEM_RECOVERY_LOG")) {
            block11: {
                block12: {
                    var4_3 = this.log_dir_s + File.separator + this.formatTime(var6_5.getTimeMillis()) + ".zip";
                    var7_6 = null;
                    try {
                        var7_6 = var6_5.getInputStream();
                        if (c.a(var7_6, new File(var4_3), this.getLogName(var6_5.getTag(), var6_5.getTimeMillis()))) break block11;
                        var8_7 = null;
                        if (var7_6 == null) break block12;
                    }
                    catch (IOException var8_8) {
                        try {
                            var8_8.printStackTrace();
                            ** if (var7_6 == null) goto lbl-1000
                        }
                        catch (Throwable var9_9) {
                            if (var7_6 != null) {
                                c.a(new Closeable[]{var7_6});
                            }
                            throw var9_9;
                        }
lbl-1000:
                        // 1 sources

                        {
                            c.a(new Closeable[]{var7_6});
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    c.a(new Closeable[]{var7_6});
                }
                return var8_7;
            }
            if (var7_6 != null) {
                c.a(new Closeable[]{var7_6});
            }
        }
        if (new File(var4_3).exists() && new File(var4_3).length() > 0L) {
            return new File(var4_3);
        }
        return null;
    }

    public String formatTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String string = simpleDateFormat.format(l);
        return string;
    }

    public String getLogName(String string, Long l) {
        return string + "@" + l + ".txt";
    }

    private void clearLog() {
        b b2 = ReportManager.getInstance(OtaAgentPolicy.sCx).getDB();
        List<ErrorFileParamInfo> list = b2.d();
        if (list.size() > 5) {
            for (ErrorFileParamInfo errorFileParamInfo : list) {
                new File(errorFileParamInfo.uploadFile).delete();
                b2.a(errorFileParamInfo);
            }
        }
    }
}

