/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Pair;
import com.abupdate.http_libs.engine.HttpManager;
import com.abupdate.iot_download_libs.DLManager;
import com.abupdate.iot_libs.MqttAgentPolicy;
import com.abupdate.iot_libs.constant.SDKConfig;
import com.abupdate.iot_libs.engine.b;
import com.abupdate.iot_libs.engine.d;
import com.abupdate.iot_libs.engine.e;
import com.abupdate.iot_libs.info.CustomDeviceInfo;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.ProductInfo;
import com.abupdate.iot_libs.info.RegisterInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.ICheckVersionCallback;
import com.abupdate.iot_libs.inter.IDownSimpleListener;
import com.abupdate.iot_libs.inter.IDownloadListener;
import com.abupdate.iot_libs.inter.IRebootUpgradeCallBack;
import com.abupdate.iot_libs.inter.IRegisterListener;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.service.JobSchedulerService;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.iot_libs.utils.a;
import com.abupdate.iot_libs.utils.c;
import com.abupdate.iot_libs.utils.j;
import com.abupdate.trace.Trace;
import java.io.File;

public class OtaAgentPolicy {
    public static Context sCx;
    public static Builder config;
    private static final String TAG = "OtaAgentPolicy";

    private static void initFota(Context context) throws FotaException {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init Fota", "--------------------------"});
        com.abupdate.iot_libs.engine.a.a().a(context);
        SDKConfig.gen();
        OtaAgentPolicy.verifyManifest(context);
        if (null == OtaAgentPolicy.config.customDeviceInfo) {
            DeviceInfo.getInstance().init();
            ProductInfo.getInstance().init();
        } else {
            DeviceInfo.getInstance().initOtherInfo(OtaAgentPolicy.config.customDeviceInfo.version, OtaAgentPolicy.config.customDeviceInfo.oem, OtaAgentPolicy.config.customDeviceInfo.models, OtaAgentPolicy.config.customDeviceInfo.platform, OtaAgentPolicy.config.customDeviceInfo.deviceType);
            if (!TextUtils.isEmpty((CharSequence)OtaAgentPolicy.config.customDeviceInfo.productId) && !TextUtils.isEmpty((CharSequence)OtaAgentPolicy.config.customDeviceInfo.product_secret)) {
                ProductInfo.getInstance().productSecret = OtaAgentPolicy.config.customDeviceInfo.product_secret;
                ProductInfo.getInstance().productId = OtaAgentPolicy.config.customDeviceInfo.productId;
            } else {
                ProductInfo.getInstance().init();
            }
        }
        RegisterInfo.getInstance().init();
        MqttAgentPolicy.initMqtt();
        a.a();
        HttpManager.build((Context)context).setRedirectTimes(0).setRetryTimes(3).create();
        if (Build.VERSION.SDK_INT >= 21) {
            OtaAgentPolicy.startJobService();
        }
    }

    @RequiresApi(api=21)
    private static void startJobService() {
        Intent intent = new Intent(sCx, JobSchedulerService.class);
        sCx.startService(intent);
        ComponentName componentName = new ComponentName(sCx, JobSchedulerService.class);
        JobInfo jobInfo = new JobInfo.Builder(888, componentName).setPeriodic(86400000L).setRequiredNetworkType(1).setPersisted(true).build();
        JobScheduler jobScheduler = (JobScheduler)sCx.getSystemService("jobscheduler");
        jobScheduler.schedule(jobInfo);
    }

    public static void registerAsync(IRegisterListener iRegisterListener) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "register", "--------------------------"});
        d.a(iRegisterListener);
        OtaService.startByAction("action_register");
    }

    public static VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    public static void checkVersionAsync(ICheckVersionCallback iCheckVersionCallback) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "check version", "--------------------------"});
        d.a(iCheckVersionCallback);
        OtaService.startByAction("action_check_version");
    }

    public static Pair<Integer, VersionInfo> checkVersionExecute() {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "check version", "--------------------------"});
        int n = e.a().c();
        Pair pair = new Pair((Object)n, (Object)VersionInfo.getInstance());
        return pair;
    }

    public static void downloadAsync(IDownloadListener iDownloadListener) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "downloadEnqueue", "--------------------------"});
        d.a(iDownloadListener);
        OtaService.startByAction("action_download");
    }

    public static boolean downloadExecute(IDownSimpleListener iDownSimpleListener) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "downloadExecute", "--------------------------"});
        return e.a().a(iDownSimpleListener);
    }

    public static boolean downloadExecute(IDownSimpleListener iDownSimpleListener, boolean bl) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "downloadExecute", "--------------------------"});
        return e.a().a(iDownSimpleListener, bl);
    }

    public static void downloadCancel() {
        Trace.d((String)TAG, (String)"downloadCancel().");
        OtaService.setDownloadCancel();
    }

    public static void rebootUpgrade(IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "reboot update", "--------------------------"});
        OtaService.startByAction("action_update");
        d.a(iRebootUpgradeCallBack);
    }

    public static void rebootLocalUpgrade(String string, IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "reboot local update", "--------------------------"});
        OtaService.startByAction("action_update", string);
        d.a(iRebootUpgradeCallBack);
    }

    private static boolean verifyManifest(Context context) {
        boolean bl = b.a(context);
        if (!bl) {
            throw new RuntimeException("AndroidManifest element and permissions is lack");
        }
        return true;
    }

    public static Builder init(Context context) {
        config = new Builder();
        sCx = context;
        SPFTool.initContext(sCx);
        OtaService.initContext(sCx);
        DLManager.getInstance().setContext(sCx);
        return config;
    }

    public static Builder getConfig() {
        return config;
    }

    public static class Builder {
        public String updatePath;
        public String tracePath;
        public boolean showTrace = true;
        public CustomDeviceInfo customDeviceInfo;
        public String mid;
        public boolean reportLog = true;

        public Builder setUpdatePath(String string) {
            Trace.d((String)OtaAgentPolicy.TAG, (String)("setUpdatePath() :" + string));
            boolean bl = c.b(new File(string).getParentFile().getAbsolutePath());
            if (bl) {
                this.updatePath = string;
            } else {
                Trace.e((String)OtaAgentPolicy.TAG, (String)"setUpdatePath() path is invalid ! set path fail");
            }
            return this;
        }

        public Builder setTracePath(String string) {
            Trace.d((String)OtaAgentPolicy.TAG, (String)("setTracePath() path:" + string));
            boolean bl = c.b(new File(string).getParentFile().getAbsolutePath());
            if (bl) {
                this.tracePath = string;
            } else {
                Trace.d((String)OtaAgentPolicy.TAG, (String)"setTracePath() path is invalid ! set path fail");
            }
            return this;
        }

        public Builder showTrace(boolean bl) {
            this.showTrace = bl;
            return this;
        }

        public Builder isReportLog(boolean bl) {
            this.reportLog = bl;
            return this;
        }

        public Builder setMid(String string) {
            this.mid = string;
            return this;
        }

        public Builder setCustomDeviceInfo(CustomDeviceInfo customDeviceInfo) {
            this.customDeviceInfo = customDeviceInfo;
            return this;
        }

        public void commit() throws FotaException {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = !TextUtils.isEmpty((CharSequence)this.updatePath) && c.b(new File(this.updatePath).getParentFile().getAbsolutePath());
            if (!bl2) {
                this.updatePath = sCx.getFilesDir() + File.separator + "update.zip";
            }
            boolean bl4 = bl = !TextUtils.isEmpty((CharSequence)this.tracePath) && c.b(new File(this.tracePath).getParentFile().getAbsolutePath());
            if (!bl) {
                this.tracePath = j.b(sCx);
            }
            Trace.setLevel((int)(this.showTrace ? 3 : 7));
            Trace.setLog_path((String)this.tracePath);
            Trace.setShowPosition((boolean)true);
            if (TextUtils.isEmpty((CharSequence)this.mid) && (null == this.customDeviceInfo || TextUtils.isEmpty((CharSequence)this.customDeviceInfo.mid))) {
                throw new RuntimeException("mid can not be null");
            }
            if (null != this.customDeviceInfo && !TextUtils.isEmpty((CharSequence)this.customDeviceInfo.mid)) {
                DeviceInfo.getInstance().initInfo(this.customDeviceInfo.mid);
            } else {
                DeviceInfo.getInstance().initInfo(this.mid);
            }
            OtaAgentPolicy.initFota(sCx);
        }
    }
}

