/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.report;

import android.content.Context;
import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.b.a;
import com.abupdate.iot_libs.info.DeviceInfo;
import com.abupdate.iot_libs.info.DownParamInfo;
import com.abupdate.iot_libs.info.PushMessageInfo;
import com.abupdate.iot_libs.info.UpgradeParamInfo;
import com.abupdate.iot_libs.info.VersionInfo;
import com.abupdate.iot_libs.inter.IReportResultCallback;
import com.abupdate.iot_libs.report.b;
import com.abupdate.iot_libs.service.OtaService;
import com.abupdate.iot_libs.utils.d;
import com.abupdate.iot_libs.utils.h;
import com.abupdate.iot_libs.utils.j;
import com.abupdate.trace.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ReportManager {
    private static String TAG = "ReportManager";
    private static ReportManager m_instance;
    private final Context m_context;
    private final b m_dbManager;

    private ReportManager(Context context) {
        this.m_context = context.getApplicationContext();
        this.m_dbManager = new b(this.m_context);
    }

    public void reportDownParamInfo(int n, long l, String string) {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case -1: {
                n3 = 8;
                break;
            }
            case -4: 
            case -2: {
                n3 = 7;
                break;
            }
            default: {
                n3 = 99;
            }
        }
        try {
            n2 = (int)new File(OtaAgentPolicy.config.updatePath).length();
        }
        catch (Exception exception) {
            n2 = 0;
        }
        DownParamInfo downParamInfo = new DownParamInfo(OtaAgentPolicy.getVersionInfo().deltaID, String.valueOf(n3), l, j.a(), n2, string);
        this.saveReportData(downParamInfo);
        OtaService.startByAction("action_report");
    }

    public void reportUpdateParamInfo(int n) {
        if (null == VersionInfo.getInstance().deltaID) {
            return;
        }
        int n2 = 99;
        switch (n) {
            case 7003: {
                n2 = 2;
                break;
            }
            case 7004: {
                n2 = 3;
                break;
            }
            case 7002: {
                n2 = 4;
                break;
            }
            case 7005: {
                n2 = 5;
                break;
            }
            default: {
                n2 = 99;
            }
        }
        UpgradeParamInfo upgradeParamInfo = new UpgradeParamInfo(DeviceInfo.getInstance().mid, VersionInfo.getInstance().deltaID, String.valueOf(n2));
        this.saveReportData(upgradeParamInfo);
        OtaService.startByAction("action_report");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportManager getInstance(Context context) {
        if (m_instance != null) return m_instance;
        Class<ReportManager> clazz = ReportManager.class;
        synchronized (ReportManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new ReportManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_instance;
        }
    }

    public int queryReport() {
        List<UpgradeParamInfo> list = this.m_dbManager.b();
        List<DownParamInfo> list2 = this.m_dbManager.a();
        List<PushMessageInfo> list3 = this.m_dbManager.c();
        return list.size() + list2.size() + list3.size();
    }

    public void saveReportData(Object object) {
        if (object instanceof UpgradeParamInfo) {
            this.m_dbManager.a((UpgradeParamInfo)object);
        } else if (object instanceof DownParamInfo) {
            this.m_dbManager.a((DownParamInfo)object);
        }
    }

    public void savePushResponseData(PushMessageInfo pushMessageInfo) {
        this.m_dbManager.b(pushMessageInfo);
    }

    public void report() {
        List<DownParamInfo> list2 = this.m_dbManager.a();
        int n = list2.size();
        if (n > 0) {
            Trace.d((String)TAG, (String)("check the local report download: " + n));
        }
        for (final DownParamInfo list3 : list2) {
            this.reportDown(list3, new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    ReportManager.this.m_dbManager.b(list3);
                }

                @Override
                public void onReportFail() {
                    ReportManager.this.m_dbManager.b(list3);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() .");
                }
            });
        }
        List<UpgradeParamInfo> list4 = this.m_dbManager.b();
        n = list4.size();
        if (n > 0) {
            Trace.d((String)TAG, (String)("check the local report upgrade: " + n));
        }
        for (final UpgradeParamInfo upgradeParamInfo : list4) {
            this.reportUpgrade(upgradeParamInfo, new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() upgrade");
                    ReportManager.this.m_dbManager.b(upgradeParamInfo);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() upgrade.");
                    ReportManager.this.m_dbManager.b(upgradeParamInfo);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() .");
                }
            });
        }
        List<PushMessageInfo> list = this.m_dbManager.c();
        n = list.size();
        if (n > 0) {
            Trace.d((String)TAG, (String)("check push message data:" + n));
        }
        for (final PushMessageInfo pushMessageInfo : list) {
            this.reportPushData(pushMessageInfo, new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() push");
                    ReportManager.this.m_dbManager.a(pushMessageInfo);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() ");
                    ReportManager.this.m_dbManager.a(pushMessageInfo);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() ");
                }
            });
        }
    }

    public void reportDown(DownParamInfo downParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string = a.a().a(downParamInfo);
            if (TextUtils.isEmpty((CharSequence)string)) {
                iReportResultCallback.onReportNetFail();
            } else {
                boolean bl = d.a(string);
                if (bl) {
                    iReportResultCallback.onReportSuccess();
                } else {
                    iReportResultCallback.onReportFail();
                }
            }
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
        }
    }

    public void reportUpgrade(UpgradeParamInfo upgradeParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string = a.a().a(upgradeParamInfo);
            if (TextUtils.isEmpty((CharSequence)string)) {
                iReportResultCallback.onReportNetFail();
            } else {
                boolean bl = d.a(string);
                if (bl) {
                    iReportResultCallback.onReportSuccess();
                } else {
                    iReportResultCallback.onReportFail();
                }
            }
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
        }
    }

    public void reportPushData(PushMessageInfo pushMessageInfo, IReportResultCallback iReportResultCallback) {
        try {
            String string = a.a().a(pushMessageInfo.msgId);
            if (TextUtils.isEmpty((CharSequence)string)) {
                iReportResultCallback.onReportNetFail();
            } else {
                boolean bl = d.a(string);
                if (bl) {
                    iReportResultCallback.onReportSuccess();
                } else {
                    iReportResultCallback.onReportFail();
                }
            }
        }
        catch (Exception exception) {
            iReportResultCallback.onReportFail();
            exception.printStackTrace();
        }
    }

    public String getLogFile() {
        Trace.d((String)TAG, (String)"getLogFile() ");
        String string = this.m_context.getExternalCacheDir() + "/otaLogs" + ".zip";
        new File(string).delete();
        String string2 = h.a(this.m_context);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Trace.d((String)TAG, (String)("getLogFile() folder = " + string2));
            try {
                File[] fileArray = new File(string2).listFiles();
                int n = Math.min(fileArray.length, 5);
                CheckedOutputStream checkedOutputStream = new CheckedOutputStream(new BufferedOutputStream(new FileOutputStream(string)), new CRC32());
                ZipOutputStream zipOutputStream = new ZipOutputStream(checkedOutputStream);
                int n2 = 0;
                if (n2 < n) {
                    int n3;
                    File file = fileArray[n2];
                    Trace.d((String)TAG, (String)("getLogFile() file path = " + file.getAbsolutePath()));
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] byArray = new byte[8192];
                    while ((n3 = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                        zipOutputStream.write(byArray, 0, n3);
                    }
                    bufferedInputStream.close();
                    Trace.d((String)TAG, (String)"getLogFile() closeEntry");
                    zipOutputStream.closeEntry();
                    zipOutputStream.finish();
                    zipOutputStream.close();
                    Trace.d((String)TAG, (String)"getLogFile() close");
                    return string;
                }
            }
            catch (Exception exception) {
                Trace.d((String)TAG, (String)("getLogFile() " + exception.getMessage()));
                exception.printStackTrace();
            }
        }
        return null;
    }
}

