/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.abupdate.iot_libs.security.FotaException;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    public static final String KEY_MID_BACK = "key_mid_back";
    public String mid;
    public String productId;
    public String productSecret;
    public String version;
    public String oem;
    public String models;
    public String platform;
    public String deviceType;
    public static Context mContext;
    public static DeviceInfo mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<DeviceInfo> clazz = DeviceInfo.class;
        synchronized (DeviceInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DeviceInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void initContext(Context context) {
        mContext = context;
    }

    public void init() throws FotaException {
        Class[] classArray;
        Object object;
        Object object2;
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init info", "--------------------------"});
        try {
            object2 = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            object = ((ApplicationInfo)object2).metaData.getString("fota_configuration_product_id");
            classArray = ((ApplicationInfo)object2).metaData.getString("fota_configuration_product_secret");
            if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)classArray) || !((String)object).startsWith("string/") || !classArray.startsWith("string/")) {
                throw new FotaException(203);
            }
            this.productId = ((String)object).replace("string/", "").trim();
            this.productSecret = classArray.replace("string/", "").trim();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new FotaException(nameNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new FotaException(203, (Throwable)nullPointerException);
        }
        try {
            object2 = mContext.getClassLoader();
            object = ((ClassLoader)object2).loadClass("android.os.SystemProperties");
            classArray = new Class[]{String.class};
            Method method = ((Class)object).getMethod("get", classArray);
            this.version = (String)method.invoke(object, "ro.fota.version");
            this.oem = (String)method.invoke(object, "ro.fota.oem");
            this.models = (String)method.invoke(object, "ro.fota.device");
            this.platform = (String)method.invoke(object, "ro.fota.platform");
            this.deviceType = (String)method.invoke(object, "ro.fota.type");
        }
        catch (Exception exception) {
            throw new FotaException(202, (Throwable)exception);
        }
        Trace.d((String)TAG, (String)String.format("productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", this.productId, this.productSecret, this.version, this.oem, this.models, this.platform, this.deviceType));
    }

    public boolean initInfo(String string) {
        Trace.d((String)TAG, (String)("set mid:" + string));
        this.mid = string;
        SPFTool.putString(KEY_MID_BACK, string);
        return this.isValid();
    }

    public void initOtherInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws FotaException {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init other info", "--------------------------"});
        this.productId = string6;
        this.productSecret = string7;
        this.oem = string2;
        this.models = string3;
        this.platform = string4;
        this.deviceType = string5;
        this.version = string;
        Trace.d((String)TAG, (String)String.format("productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", string6, string7, string, string2, string3, string4, string5));
    }

    public boolean isValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.mid)) {
            Trace.d((String)TAG, (String)"isValid() mid = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.oem)) {
            Trace.d((String)TAG, (String)"isValid() oem = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.models)) {
            Trace.d((String)TAG, (String)"isValid() models = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.platform)) {
            Trace.d((String)TAG, (String)"isValid() platform = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceType)) {
            Trace.d((String)TAG, (String)"isValid() deviceType = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productSecret)) {
            Trace.d((String)TAG, (String)"isValid() product_secret = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() product id = null");
            bl = false;
        }
        return bl;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("mid", (Object)this.mid);
            jSONObject.put("version", (Object)this.version);
            jSONObject.put("oem", (Object)this.oem);
            jSONObject.put("models", (Object)this.models);
            jSONObject.put("platform", (Object)this.platform);
            jSONObject.put("deviceType", (Object)this.deviceType);
            jSONObject.put("productId", (Object)this.productId);
            jSONObject.put("productSecret", (Object)this.productSecret);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }
}

