/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.iot_libs.info;

import android.text.TextUtils;
import com.abupdate.iot_libs.OtaAgentPolicy;
import com.abupdate.iot_libs.constant.Error;
import com.abupdate.iot_libs.inter.IRegisterListener;
import com.abupdate.iot_libs.utils.SPFTool;
import com.abupdate.trace.Trace;

public class RegisterInfo {
    private static final String TAG = "RegisterInfo";
    private static RegisterInfo registerInfo;
    public String deviceSecret;
    public String deviceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterInfo getInstance() {
        if (registerInfo != null) return registerInfo;
        Class<RegisterInfo> clazz = RegisterInfo.class;
        synchronized (RegisterInfo.class) {
            if (registerInfo != null) return registerInfo;
            registerInfo = new RegisterInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registerInfo;
        }
    }

    public void init() {
        String string = SPFTool.getString("deviceSecret", "");
        String string2 = SPFTool.getString(SPFTool.KEY_DEVICE_ID, "");
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            Trace.d((String)TAG, (String)"init() first register");
            OtaAgentPolicy.registerAsync(new IRegisterListener(){

                @Override
                public void onSuccess() {
                    Trace.d((String)RegisterInfo.TAG, (String)"init() register success ");
                }

                @Override
                public void onFailed(int n) {
                    Trace.w((String)RegisterInfo.TAG, (String)("init() register fail, " + Error.getErrorMessage(n)));
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.deviceSecret = string;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.deviceId = string2;
        }
    }

    public boolean isValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.deviceSecret)) {
            Trace.d((String)TAG, (String)"isValid() deviceSecret = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceId)) {
            Trace.d((String)TAG, (String)"isValid() deviceId = null");
            bl = false;
        }
        return bl;
    }

    public void reset() {
        Trace.d((String)TAG, (String)"register info reset");
        this.deviceSecret = null;
        this.deviceId = null;
        SPFTool.putString("deviceSecret", "");
        SPFTool.putString(SPFTool.KEY_DEVICE_ID, "");
    }
}

