/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.inter;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.b.b;
import com.adups.iot_libs.info.PushMessageInfo;
import com.adups.iot_libs.inter.ILoginCallback;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IReportDeviceStatusCallback;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.d;
import com.adups.iot_libs.utils.i;
import com.adups.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.trace.Trace;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageListener
implements MqttCallback {
    private static final String TAG = "MessageListener";
    private static final String LOGOUT_RESPONSE = "logout/response";
    private static final String LOGIN_RESPONSE = "login/response";
    private static final String REPORT_DEVICE_STATUS_RESPONSE = "update/response";
    private static final String PUSH_NOTIFY = "notify";
    public static final int DISCONNECTED_OK = -1;
    private Context mCx;
    private ILoginCallback mILoginCallback;
    private ILogoutCallback mILogoutCallback;
    private IReportDeviceStatusCallback mIReportDeviceStatusCallback;
    private static final int RESPONSE_TIMEOUT = 5000;
    private boolean timeout = true;
    private static MessageListener messageListener;
    private a mConnectionLostListener;
    private b currentState = b.a;

    private MessageListener() {
        this.mCx = OtaAgentPolicy.sCx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageListener getInstance() {
        if (messageListener != null) return messageListener;
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            if (messageListener != null) return messageListener;
            messageListener = new MessageListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return messageListener;
        }
    }

    public void connectionLost(Throwable throwable) {
        Trace.d((String)TAG, (String)"connectionLost() ");
        if (null != this.mConnectionLostListener) {
            int n = null != throwable && throwable instanceof MqttException ? ((MqttException)throwable).getReasonCode() : (throwable == null ? -1 : 6);
            this.mConnectionLostListener.onConnectLost(n);
        }
    }

    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        JSONObject jSONObject;
        String string2 = new String(mqttMessage.getPayload());
        Trace.d((String)TAG, (String)("messageArrived() :" + string));
        Trace.d((String)TAG, (String)("messageArrived() :" + string2));
        if (this.currentState == b.a && !string.endsWith(PUSH_NOTIFY)) {
            Trace.d((String)TAG, (String)"messageArrived() state is null");
            return;
        }
        if (string.endsWith(LOGIN_RESPONSE)) {
            String string3 = this.getReply(string2);
            if (com.adups.iot_libs.b.b.a().a(1000, string3)) {
                this.timeout = false;
                int n = d.b(string2);
                if (d.b(n)) {
                    Trace.d((String)TAG, (String)"messageArrived() login response success!");
                    this.mILoginCallback.onLoginSuccess();
                    com.adups.iot_libs.b.b.a().a(b.a.d);
                } else {
                    Trace.d((String)TAG, (String)"messageArrived() login response failed!");
                    this.mILoginCallback.onLoginFail(n);
                }
            }
        } else if (string.endsWith(LOGOUT_RESPONSE)) {
            String string4 = this.getReply(string2);
            if (com.adups.iot_libs.b.b.a().a(1001, string4)) {
                Trace.d((String)TAG, (String)"messageArrived() logout response success!");
                this.timeout = false;
                int n = d.b(string2);
                if (d.b(n)) {
                    this.mILogoutCallback.onLogoutSuccess();
                    com.adups.iot_libs.b.b.a().a(b.a.e);
                } else {
                    this.mILogoutCallback.onLogoutFail(n);
                }
            }
        } else if (string.endsWith(REPORT_DEVICE_STATUS_RESPONSE)) {
            String string5 = this.getReply(string2);
            if (com.adups.iot_libs.b.b.a().a(1002, string5)) {
                Trace.d((String)TAG, (String)"messageArrived() report device info success");
                this.timeout = false;
                int n = d.b(string2);
                if (d.b(n)) {
                    this.mIReportDeviceStatusCallback.onReportSuccess();
                } else {
                    this.mIReportDeviceStatusCallback.onReportFail(n);
                }
            }
        } else if (string.endsWith(PUSH_NOTIFY) && (jSONObject = new JSONObject(string2)).has("body")) {
            String string6;
            JSONObject jSONObject2 = jSONObject.getJSONObject("body");
            if (jSONObject2.has("content")) {
                string6 = jSONObject2.getString("content");
                Intent intent = new Intent();
                intent.setAction("action_fota_notify");
                intent.putExtra("key_fota_notify", string6);
                LocalBroadcastManager.getInstance((Context)this.mCx).sendBroadcast(intent);
            }
            if (jSONObject2.has("msgId")) {
                string6 = jSONObject2.getString("msgId");
                ReportManager.getInstance(this.mCx).savePushResponseData(new PushMessageInfo(string6));
                OtaService.startByAction("action_report");
            }
        }
    }

    private String getReply(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("replyno")) {
                String string2 = jSONObject.getString("replyno");
                return string2;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return "";
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    private void response(String string, boolean bl) {
        Trace.d((String)TAG, (String)("response() start. action = " + string));
        if (null == this.mCx) {
            Trace.d((String)TAG, (String)"response() Context is null!");
            return;
        }
        Intent intent = new Intent();
        intent.setAction(string);
        intent.putExtra("key_fota_response", bl);
        LocalBroadcastManager.getInstance((Context)this.mCx).sendBroadcast(intent);
    }

    public void setLoginListener(ILoginCallback iLoginCallback) {
        this.mILoginCallback = iLoginCallback;
        this.setCurrentState(b.b);
        this.timeStart();
    }

    public void setLogoutListener(ILogoutCallback iLogoutCallback) {
        this.mILogoutCallback = iLogoutCallback;
        this.setCurrentState(b.c);
        this.timeStart();
    }

    public void setReportDeviceStatusListener(IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        this.mIReportDeviceStatusCallback = iReportDeviceStatusCallback;
        this.setCurrentState(b.d);
        this.timeStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStart() {
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            i.a().a(new com.adups.iot_libs.inter.b(){

                @Override
                public void a() {
                    if (MessageListener.this.timeout) {
                        if (MessageListener.this.currentState == b.b) {
                            MessageListener.this.mILoginCallback.onLoginTimeout();
                        }
                        if (MessageListener.this.currentState == b.c) {
                            MessageListener.this.mILogoutCallback.onLogoutTimeout();
                        }
                        if (MessageListener.this.currentState == b.d) {
                            MessageListener.this.mIReportDeviceStatusCallback.onReportFail(32000);
                        }
                        MessageListener.this.setCurrentState(b.a);
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setCurrentState(b b2) {
        this.timeout = true;
        this.currentState = b2;
    }

    public void setConnectionLostListener(a a2) {
        this.mConnectionLostListener = a2;
    }

    public static interface a {
        public void onConnectLost(int var1);
    }

    static enum b {
        a,
        b,
        c,
        d;

    }
}

