/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs;

import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.b.b;
import com.adups.iot_libs.inter.IReportDeviceStatusCallback;
import com.adups.iot_libs.inter.IStatusListener;
import com.adups.iot_libs.inter.MessageListener;
import com.adups.iot_libs.inter.OtaListener;
import com.adups.iot_libs.service.OtaService;
import com.adups.mqtt_libs.connect.MqttManager;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.trace.Trace;

public class MqttAgentPolicy {
    private static final String TAG = "MqttAgentPolicy";

    public static void initMqtt() {
        MqttManager.getInstance().setContext(OtaAgentPolicy.sCx);
        MqttManager.getInstance().registerMessageListener((MqttCallback)MessageListener.getInstance());
        MqttManager.getInstance().setTraceEnable(false);
    }

    public static void registerStatusListener(IStatusListener iStatusListener) {
        OtaListener.getInstance().addListener(OtaListener.a.a, iStatusListener);
    }

    public static boolean unregisterStatusListener(IStatusListener iStatusListener) {
        return OtaListener.getInstance().removeListener(OtaListener.a.a, iStatusListener);
    }

    public static void disConnect() {
        if (MqttManager.getInstance().isKeepConnect()) {
            MqttManager.getInstance().stopKeepConnect();
            OtaService.startByAction("action_disconnect");
            return;
        }
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"disConnect() is disconnected");
            OtaListener.getInstance().disconnect(new MqttException(new Throwable("is disconnected")));
            return;
        }
        if (b.a().b() == b.a.f) {
            Trace.d((String)TAG, (String)"disConnect() is disconnecting");
            OtaListener.getInstance().disconnect(new MqttException(new Throwable("is disconnecting")));
            return;
        }
        OtaService.startByAction("action_disconnect");
    }

    public static void stopKeepConnect() {
        Trace.d((String)TAG, (String)"stopKeepConnect() start.");
        if (MqttManager.getInstance().isKeepConnect()) {
            OtaService.startByAction("action_disconnect");
        } else {
            Trace.d((String)TAG, (String)"stopKeepConnect() is not config keep connect!");
        }
    }

    public static void connect() {
        if (MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"connect() is connected");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connected")));
            return;
        }
        if (b.a().b() == b.a.b) {
            Trace.d((String)TAG, (String)"connect() is connecting");
            OtaListener.getInstance().connect(new MqttException(new Throwable("is connecting")));
            return;
        }
        OtaService.startByAction("action_connect");
    }

    public static void reportDeviceStatus(String string, IReportDeviceStatusCallback iReportDeviceStatusCallback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)TAG, (String)"reportDeviceStatus() is disconnected");
            return;
        }
        if (b.a().b() != b.a.d) {
            Trace.e((String)TAG, (String)"reportDeviceStatus() device is off line");
            return;
        }
        b.a().a(string, iReportDeviceStatusCallback);
    }

    public static boolean isConnected() {
        return MqttManager.getInstance().isConneect();
    }
}

