/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.trace.Trace;
import java.io.File;

public class UpgradeReceiver
extends BroadcastReceiver {
    private Context a;

    public void onReceive(Context context, Intent intent) {
        this.a = context;
        String string = intent.getAction();
        Trace.d((String)"UpgradeReceiver", (String)("action: " + string));
        this.a(string);
    }

    private void a(String string) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            this.b();
        } else if ("android.intent.action.BOOT_COMPLETED".equals(string)) {
            this.a();
        }
    }

    private void a() {
        SPFTool.putBoolean("key_should_report", true);
        String string = SPFTool.getString("key_version_name", "");
        String string2 = SPFTool.getString("KEY_DELTAID", "");
        Trace.d((String)"UpgradeReceiver", (String)("boot_process() " + string + "," + string2));
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            Object object;
            SPFTool.putString("key_version_name", "");
            SPFTool.putString("KEY_DELTAID", "");
            Trace.i((String)"UpgradeReceiver", (String)("mobile version:" + DeviceInfo.getInstance().version + " update version " + string));
            boolean bl = string.equals(DeviceInfo.getInstance().version);
            Intent intent = new Intent("action_fota_update_result");
            intent.putExtra("key_fota_update_result", bl);
            LocalBroadcastManager.getInstance((Context)this.a).sendBroadcast(intent);
            if (bl) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update success!");
                object = SPFTool.getString("key_update_file_path", "");
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    new File((String)object).delete();
                }
            } else {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update failed!");
            }
            object = new UpgradeParamInfo(DeviceInfo.getInstance().mid, string2, String.valueOf(bl ? 1 : 99));
            ReportManager.getInstance(this.a).saveReportData(object);
            if (this.a(this.a)) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() boot complete upgrade report");
                this.c();
            }
        }
    }

    private void b() {
        if (Build.VERSION.SDK_INT < 21) {
            if (this.a(this.a)) {
                Trace.d((String)"UpgradeReceiver", (String)("network_process() should_report = " + SPFTool.getBoolean("key_should_report", false)));
                if (SPFTool.getBoolean("key_should_report", false)) {
                    this.c();
                }
            }
            if (System.currentTimeMillis() - SPFTool.getLong("spf_static_check_version_cycle", -1L) >= 259200000L) {
                OtaService.startByAction("action_static_check_version");
                SPFTool.putLong("spf_static_check_version_cycle", System.currentTimeMillis());
            }
        }
    }

    private void c() {
        if (ReportManager.getInstance(this.a).queryReport() == 0) {
            SPFTool.putBoolean("key_should_report", false);
            Trace.d((String)"UpgradeReceiver", (String)"report() do not have data to be reported!");
            return;
        }
        OtaService.startByAction("action_report");
    }

    private boolean a(Context context) {
        boolean bl = false;
        if (context == null) {
            return bl;
        }
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return bl;
            }
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            if (networkInfoArray == null) {
                return bl;
            }
            for (int k = 0; k < networkInfoArray.length && networkInfoArray[k] != null; ++k) {
                if (!networkInfoArray[k].isConnected() || !networkInfoArray[k].isAvailable()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            Trace.d((String)"UpgradeReceiver", (String)"==Util:isNetWorkAvailable Exception");
        }
        return bl;
    }
}

