/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.adups.http_libs.engine.HttpManager;
import com.adups.iot_libs.MqttAgentPolicy;
import com.adups.iot_libs.a.a;
import com.adups.iot_libs.constant.SDKConfig;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.iot_libs.inter.ICheckVersionCallback;
import com.adups.iot_libs.inter.IDownloadListener;
import com.adups.iot_libs.inter.IRebootUpgradeCallBack;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.security.FotaException;
import com.adups.iot_libs.service.JobSchedulerService;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.iot_libs.utils.c;
import com.adups.iot_libs.utils.e;
import com.adups.iot_libs.utils.j;
import com.adups.trace.Trace;
import java.io.File;
import javax.net.ssl.HostnameVerifier;

public class OtaAgentPolicy {
    public static Context sCx;
    private static String mPath;
    private static String logPath;
    private static final String TAG = "OtaAgentPolicy";

    public static void initFota(Context context) throws FotaException {
        Trace.setLevel((int)3);
        logPath = j.b(context);
        Trace.setLog_path((String)logPath);
        Trace.setShowPosition((boolean)true);
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "init Fota", "--------------------------"});
        sCx = context;
        mPath = sCx.getFilesDir() + File.separator + "update.zip";
        SDKConfig.isTest(false);
        OtaAgentPolicy.verifyManifest(context);
        SPFTool.initContext(context);
        OtaService.initContext(context);
        DeviceInfo.initContext(context);
        DeviceInfo.getInstance().init();
        MqttAgentPolicy.initMqtt();
        HttpManager.build((Context)sCx).setRedirectTimes(0).setRetryTimes(3).setSSL(new String(SDKConfig.KEY), "/assets/adcom.bks", (HostnameVerifier)new e()).create();
        if (Build.VERSION.SDK_INT >= 21) {
            OtaAgentPolicy.startJobService();
        }
    }

    @RequiresApi(api=21)
    private static void startJobService() {
        Intent intent = new Intent(sCx, JobSchedulerService.class);
        sCx.startService(intent);
        ComponentName componentName = new ComponentName(sCx, JobSchedulerService.class);
        JobInfo jobInfo = new JobInfo.Builder(888, componentName).setPeriodic(259200000L).setRequiredNetworkType(1).setPersisted(true).build();
        JobScheduler jobScheduler = (JobScheduler)sCx.getSystemService("jobscheduler");
        jobScheduler.schedule(jobInfo);
    }

    public static boolean setUpdatePath(String string) {
        Trace.d((String)TAG, (String)("setUpdatePath() :" + string));
        boolean bl = c.b(new File(string).getParentFile().getAbsolutePath());
        if (bl) {
            mPath = string;
        } else {
            Trace.e((String)TAG, (String)"setUpdatePath() path is invalid ! set path fail");
        }
        return bl;
    }

    public static void showTrace(boolean bl) {
        Trace.setLevel((int)(bl ? 3 : 7));
    }

    public static boolean setTracePath(String string) {
        Trace.d((String)TAG, (String)("setTracePath() path:" + string));
        boolean bl = c.b(new File(string).getParentFile().getAbsolutePath());
        if (bl) {
            logPath = string;
            Trace.setLog_path((String)logPath);
        } else {
            Trace.d((String)TAG, (String)"setTracePath() path is invalid ! set path fail");
        }
        return bl;
    }

    public static String getTracePath() {
        return logPath;
    }

    public static void setDeviceInfo(String string) throws FotaException {
        DeviceInfo.getInstance().initInfo(string);
        RegisterInfo.getInstance().init();
    }

    public static void setTestDeviceInfo(String string, String string2, String string3, String string4, String string5) throws FotaException {
        DeviceInfo.getInstance().initOtherInfo(string, string2, string3, string4, string5);
    }

    public static void register(IRegisterListener iRegisterListener) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "register", "--------------------------"});
        OtaService.setRegisterListener(iRegisterListener);
        OtaService.startByAction("action_register");
    }

    public static VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    public static void checkVersion(ICheckVersionCallback iCheckVersionCallback) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "check version", "--------------------------"});
        OtaService.setCheckVersionListener(iCheckVersionCallback);
        OtaService.startByAction("action_check_version");
    }

    public static void download(IDownloadListener iDownloadListener) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "download", "--------------------------"});
        OtaService.setDownloadListener(iDownloadListener);
        OtaService.startByAction("action_download");
    }

    public static void downloadCancel() {
        Trace.d((String)TAG, (String)"downloadCancel().");
        OtaService.setDownloadCancel();
    }

    public static void rebootUpgrade(IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "reboot update", "--------------------------"});
        OtaService.startByAction("action_update");
        OtaService.setUpdateCallBack(iRebootUpgradeCallBack);
    }

    public static void rebootLocalUpgrade(String string, IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"%s%s%s", (Object[])new Object[]{"--------------------------", "reboot local update", "--------------------------"});
        OtaService.startByAction("action_update");
        OtaService.setUpdateCallBack(iRebootUpgradeCallBack);
        OtaService.setLocalUpgrade(string);
    }

    public static String getPackagePath() {
        if (null == mPath) {
            Trace.d((String)TAG, (String)"getPackagePath() path is null,please call method initFota()!");
            return null;
        }
        return mPath;
    }

    private static boolean verifyManifest(Context context) {
        boolean bl = a.a(context);
        if (!bl) {
            throw new RuntimeException("AndroidManifest element and permissions is lack");
        }
        return true;
    }
}

