/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.RecoverySystem;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.adups.iot_download_libs.DLManager;
import com.adups.iot_download_libs.DownEntity;
import com.adups.iot_download_libs.IOnDownListener;
import com.adups.iot_libs.MqttAgentPolicy;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.b.a;
import com.adups.iot_libs.b.b;
import com.adups.iot_libs.constant.Error;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.DownParamInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.iot_libs.inter.ICheckVersionCallback;
import com.adups.iot_libs.inter.IDownloadListener;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IRebootUpgradeCallBack;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.inter.OtaListener;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.iot_libs.utils.c;
import com.adups.iot_libs.utils.e;
import com.adups.trace.Trace;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class OtaService
extends IntentService {
    public static final String ACTION_REGISTER = "action_register";
    public static final String ACTION_CHECK_VERSION = "action_check_version";
    public static final String ACTION_CONNECT = "action_connect";
    public static final String ACTION_DISCONNECT = "action_disconnect";
    public static final String ACTION_DOWNLOAD = "action_download";
    public static final String ACTION_UPDATE = "action_update";
    public static final String ACTION_REPORT = "action_report";
    public static final String TAG = "OtaService";
    private static Context a;
    private static IDownloadListener b;
    private static ICheckVersionCallback c;
    private static IRegisterListener d;
    private static IRebootUpgradeCallBack e;
    private static String f;
    private Handler g;
    private static long h;
    private static boolean i;
    private static String j;

    public OtaService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.g = new Handler();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        String string;
        if (intent == null) {
            return;
        }
        switch (string = intent.getStringExtra("key_action")) {
            case "action_register": {
                this.k();
                break;
            }
            case "action_check_version": {
                this.h();
                break;
            }
            case "action_connect": {
                this.j();
                break;
            }
            case "action_disconnect": {
                this.i();
                break;
            }
            case "action_download": {
                this.g();
                break;
            }
            case "action_update": {
                if (i) {
                    this.rebootLocalUpgrade();
                    break;
                }
                this.f();
                break;
            }
            case "action_report": {
                this.e();
            }
        }
    }

    private void e() {
        ReportManager.getInstance(a).report();
    }

    private void f() {
        Trace.d((String)TAG, (String)"upgrade() start.");
        if (null == e) {
            Trace.e((String)TAG, (String)"upgrade() sIRebootUpgradeCallBack is null,please call method setUpdateCallBack()!");
            return;
        }
        String string = OtaAgentPolicy.getPackagePath();
        Trace.d((String)TAG, (String)("rebootUpgrade() path:" + string));
        if (!com.adups.iot_libs.utils.b.a(string, VersionInfo.getInstance().md5sum)) {
            Trace.e((String)TAG, (String)"onUpdateFail() . update validate file fail");
            this.a(7005, "update validate file fail");
            this.b(7005);
            return;
        }
        this.a(new File(string), e);
    }

    public void rebootLocalUpgrade() {
        String string = f;
        Trace.d((String)TAG, (String)("rebootLocalUpgrade() path:" + string));
        if (e == null) {
            Trace.e((String)TAG, (String)"rebootUpgrade() IRebootUpgradeCallBack is null");
            this.b(7005);
            return;
        }
        if (string == null) {
            Trace.e((String)TAG, (String)"rebootLocalUpgrade() path is null");
            this.a(7002, "path is null");
            this.b(7002);
            return;
        }
        this.a(new File(string), e);
    }

    private void a(File file, IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        if (!file.exists() || file.length() == 0L) {
            Trace.e((String)TAG, (String)"onUpdateFail() .The updatePath file is not exist or file length is 0");
            this.a(7002, "The updatePath file is not exist or file length is 0");
            this.b(7002);
            return;
        }
        if (file.getAbsoluteFile() != null && OtaAgentPolicy.getVersionInfo().versionName != null && OtaAgentPolicy.getVersionInfo().deltaID != null) {
            SPFTool.putString(a, "key_update_file_path", file.getAbsolutePath());
            SPFTool.putString(a, "key_version_name", OtaAgentPolicy.getVersionInfo().versionName);
            SPFTool.putString(a, "KEY_DELTAID", OtaAgentPolicy.getVersionInfo().deltaID);
            Trace.d((String)TAG, (String)("rebootUpgrade() version_name = " + SPFTool.getString(a, "key_version_name", "null") + ",deltaId:" + SPFTool.getString(a, "KEY_DELTAID", "null")));
        }
        try {
            RecoverySystem.installPackage((Context)a, (File)file);
        }
        catch (IOException iOException) {
            Trace.e((String)TAG, (String)"onUpdateFail() .", (Throwable)iOException);
            this.a(7004, iOException.toString());
            this.b(7004);
        }
    }

    private void g() {
        if (null == b) {
            Trace.d((String)TAG, (String)"download_task(). downloadListener is null,please call method setDownloadListener();");
            return;
        }
        ReportManager.getInstance(a).report();
        h = System.currentTimeMillis();
        String string = OtaAgentPolicy.getPackagePath();
        DownEntity downEntity = new DownEntity(VersionInfo.getInstance().deltaUrl, string, VersionInfo.getInstance().fileSize, VersionInfo.getInstance().md5sum);
        DLManager.getInstance().add(downEntity);
        DLManager.getInstance().execAsync(new IOnDownListener(){

            public void on_start() {
                OtaService.this.onCallbackMainThread(1, 0L, 0L, 0);
                OtaService.this.m();
            }

            public void on_finished(List<DownEntity> list, List<DownEntity> list2) {
            }

            public void on_success(DownEntity downEntity) {
                Trace.d((String)OtaService.TAG, (String)("on_success() " + downEntity));
                OtaService.reportDownParamInfo(0);
                OtaService.this.onCallbackMainThread(4, 0L, 0L, 0);
            }

            public void on_failed(DownEntity downEntity) {
                Trace.d((String)OtaService.TAG, (String)("on_failed() " + downEntity));
                OtaService.this.onCallbackMainThread(5, 0L, 0L, downEntity.download_status);
                OtaService.reportDownParamInfo(downEntity.download_status);
            }

            public void on_manual_cancel() {
                OtaService.this.onCallbackMainThread(3, 0L, 0L, 0);
            }

            public void on_all_progress(int n, long l, long l2) {
            }

            public void on_progress(DownEntity downEntity, int n, long l, long l2) {
                OtaService.this.onCallbackMainThread(2, l, l2, 0);
            }
        });
    }

    private void h() {
        String string;
        if (null == c) {
            Trace.e((String)TAG, (String)"check_version_task() checkVersionListener is null,please call method setCheckVersionListener()!");
            return;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.e((String)TAG, (String)"check_version_task() device info is invalid!");
            this.a(3001);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceSecret) || TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceId)) {
            Trace.d((String)TAG, (String)"check_version_task() start register!");
            if (!this.k() && null == RegisterInfo.getInstance().deviceSecret && null == RegisterInfo.getInstance().deviceId) {
                this.a(2003);
                return;
            }
        }
        if (TextUtils.isEmpty((CharSequence)(string = com.adups.iot_libs.b.a.a().b(DeviceInfo.getInstance(), a)))) {
            Trace.e((String)TAG, (String)"check_version_task() json is null!");
            this.a(3003);
            return;
        }
        int n = com.adups.iot_libs.utils.c.a(a, string);
        if (com.adups.iot_libs.utils.c.a(n)) {
            this.l();
        } else {
            this.a(n);
        }
    }

    private void i() {
        Trace.d((String)TAG, (String)"disConnectMqtt() ");
        if (MqttAgentPolicy.isConnected()) {
            if (com.adups.iot_libs.b.b.a().b() == b.a.d) {
                com.adups.iot_libs.b.b.a().a(b.a.f);
                com.adups.iot_libs.b.b.a().a(true, new ILogoutCallback(){

                    @Override
                    public void onLogoutSuccess() {
                        com.adups.iot_libs.b.b.a().a(OtaListener.getInstance().setAction(OtaListener.a.b));
                    }

                    @Override
                    public void onLogoutFail(int n) {
                        com.adups.iot_libs.b.b.a().a(OtaListener.getInstance().setAction(OtaListener.a.b));
                    }

                    @Override
                    public void onLogoutTimeout() {
                        com.adups.iot_libs.b.b.a().a(OtaListener.getInstance().setAction(OtaListener.a.b));
                    }
                });
            } else {
                com.adups.iot_libs.b.b.a().a(b.a.f);
                com.adups.iot_libs.b.b.a().a(OtaListener.getInstance().setAction(OtaListener.a.b));
            }
        }
    }

    private void j() {
        Trace.d((String)TAG, (String)"connectMqtt() ");
        if (TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceSecret) || TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceId)) {
            Trace.e((String)TAG, (String)"connectMqtt() please register!");
            return;
        }
        com.adups.iot_libs.b.b.a().a(b.a.b);
        com.adups.iot_libs.b.b.a().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startByAction(String string) {
        Class<OtaService> clazz = OtaService.class;
        synchronized (OtaService.class) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                Trace.e((String)TAG, (String)"startByAction() action is null");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (null == a) {
                Trace.e((String)TAG, (String)"startByAction() context is null,should call initContext();");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Intent intent = new Intent();
            intent.putExtra("key_action", string);
            intent.setClass(a, OtaService.class);
            a.startService(intent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean k() {
        if (null == a) {
            Trace.e((String)TAG, (String)"register_task() context is null,please call method initContext() in application!");
            return false;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.e((String)TAG, (String)"register_task() failed. device info is null");
            return false;
        }
        String string = com.adups.iot_libs.b.a.a().a(DeviceInfo.getInstance(), a);
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (null != d) {
                d.onFailed(3003);
            }
            return false;
        }
        int n = com.adups.iot_libs.utils.c.a(string, a);
        if (n == 1000) {
            if (null != d) {
                d.onSuccess();
            }
            return true;
        }
        if (null != d) {
            d.onFailed(n);
        }
        return false;
    }

    public static void initContext(Context context) {
        a = context;
    }

    public static void setRegisterListener(IRegisterListener iRegisterListener) {
        d = iRegisterListener;
    }

    public static void setDownloadListener(IDownloadListener iDownloadListener) {
        b = iDownloadListener;
    }

    public static void setCheckVersionListener(ICheckVersionCallback iCheckVersionCallback) {
        c = iCheckVersionCallback;
    }

    public static void setUpdateCallBack(IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        e = iRebootUpgradeCallBack;
        i = false;
    }

    public static void setDownloadCancel() {
        DLManager.getInstance().cancel_all();
    }

    private void l() {
        Trace.d((String)TAG, (String)"=================onCheckVersionSuccess=================");
        this.g.post(new Runnable(){

            @Override
            public void run() {
                c.onCheckSuccess(VersionInfo.getInstance());
            }
        });
    }

    private void a(final int n) {
        Trace.d((String)TAG, (String)("=================onCheckVersionFailed================= \n error:" + Error.getErrorMessage(n)));
        if (c != null) {
            this.g.post(new Runnable(){

                @Override
                public void run() {
                    if (c != null) {
                        c.onCheckFail(n);
                    }
                }
            });
        }
    }

    private void a(final int n, final String string) {
        Trace.e((String)TAG, (String)("=================onUpdateFailed=================\n error:" + n));
        this.g.post(new Runnable(){

            @Override
            public void run() {
                if (e != null) {
                    e.onError(n, string);
                }
            }
        });
    }

    public static void reportDownParamInfo(int n) {
        int n2;
        int n3;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case -1: {
                n3 = 8;
                break;
            }
            case -2: {
                n3 = 7;
                break;
            }
            default: {
                n3 = 99;
            }
        }
        try {
            n2 = (int)new File(OtaAgentPolicy.getPackagePath()).length();
        }
        catch (Exception exception) {
            n2 = 0;
        }
        DownParamInfo downParamInfo = new DownParamInfo(OtaAgentPolicy.getVersionInfo().deltaID, String.valueOf(n3), h, System.currentTimeMillis(), n2, j);
        ReportManager.getInstance(a).saveReportData(downParamInfo);
        ReportManager.getInstance(a).report();
    }

    public static void setLocalUpgrade(String string) {
        f = string;
        i = true;
    }

    private void b(int n) {
        if (null == VersionInfo.getInstance().deltaID) {
            return;
        }
        int n2 = 99;
        switch (n) {
            case 7003: {
                n2 = 2;
                break;
            }
            case 7004: {
                n2 = 3;
                break;
            }
            case 7002: {
                n2 = 4;
                break;
            }
            case 7005: {
                n2 = 5;
                break;
            }
            default: {
                n2 = 99;
            }
        }
        UpgradeParamInfo upgradeParamInfo = new UpgradeParamInfo(DeviceInfo.getInstance().mid, VersionInfo.getInstance().deltaID, String.valueOf(n2));
        ReportManager.getInstance(a).saveReportData(upgradeParamInfo);
        this.e();
    }

    public void onCallbackMainThread(final int n, final long l, final long l2, final int n2) {
        this.g.post(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 1: {
                        b.onPrepare();
                        break;
                    }
                    case 2: {
                        b.onDownloadProgress(l, l2);
                        break;
                    }
                    case 3: {
                        b.onCancel();
                        break;
                    }
                    case 4: {
                        b.onCompleted();
                        break;
                    }
                    case 5: {
                        b.onFailed(n2);
                        break;
                    }
                    default: {
                        b.onFailed(8003);
                    }
                }
            }
        });
    }

    private void m() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(com.adups.iot_libs.utils.e.a(VersionInfo.getInstance().deltaUrl));
                    j = inetAddress.getHostAddress();
                    Trace.d((String)OtaService.TAG, (String)("download_task() download IP:" + j));
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                }
            }
        }).start();
    }

    static {
        i = false;
        j = "";
    }
}

