/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.adups.iot_libs.security.FotaException;
import com.adups.trace.Trace;
import java.lang.reflect.Method;

public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private static final String KEY_MOBILE_PARAMS = "key_mobile_params";
    public String mid;
    public String productId;
    public String product_secret;
    public String version;
    public String oem;
    public String models;
    public String platform;
    public String deviceType;
    public static DeviceInfo mInstance;
    public static Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<DeviceInfo> clazz = DeviceInfo.class;
        synchronized (DeviceInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DeviceInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void initContext(Context context) {
        mContext = context;
    }

    public void initInfo(String string) throws FotaException {
        Class[] classArray;
        Object object;
        Object object2;
        Trace.d((String)TAG, (String)"--------------initInfo--------------");
        this.mid = string;
        try {
            object2 = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            object = ((ApplicationInfo)object2).metaData.getString("fota_configuration_product_id");
            classArray = ((ApplicationInfo)object2).metaData.getString("fota_configuration_product_secret");
            if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)classArray) || !((String)object).startsWith("string/") || !classArray.startsWith("string/")) {
                throw new FotaException(203);
            }
            this.productId = ((String)object).replace("string/", "").trim();
            this.product_secret = classArray.replace("string/", "").trim();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new FotaException(nameNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new FotaException(203, (Throwable)nullPointerException);
        }
        try {
            object2 = mContext.getClassLoader();
            object = ((ClassLoader)object2).loadClass("android.os.SystemProperties");
            classArray = new Class[]{String.class};
            Method method = ((Class)object).getMethod("get", classArray);
            this.version = (String)method.invoke(object, "ro.fota.version");
            this.oem = (String)method.invoke(object, "ro.fota.oem");
            this.models = (String)method.invoke(object, "ro.fota.device");
            this.platform = (String)method.invoke(object, "ro.fota.platform");
            this.deviceType = (String)method.invoke(object, "ro.fota.type");
        }
        catch (Exception exception) {
            throw new FotaException(202, (Throwable)exception);
        }
    }

    public boolean initOtherInfo(String string, String string2, String string3, String string4, String string5, String string6) throws FotaException {
        Trace.d((String)TAG, (String)"-------------initOtherInfo------------- ");
        this.mid = string;
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            String string7 = applicationInfo.metaData.getString("fota_configuration_product_id");
            String string8 = applicationInfo.metaData.getString("fota_configuration_product_secret");
            if (TextUtils.isEmpty((CharSequence)string7) || TextUtils.isEmpty((CharSequence)string8) || !string7.startsWith("string/") || !string8.startsWith("string/")) {
                throw new FotaException(203);
            }
            this.productId = string7.replace("string/", "").trim();
            this.product_secret = string8.replace("string/", "").trim();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            throw new FotaException(nameNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new FotaException(203, (Throwable)nullPointerException);
        }
        this.oem = string3;
        this.models = string4;
        this.platform = string5;
        this.deviceType = string6;
        this.version = string2;
        boolean bl = this.isValid();
        Trace.d((String)TAG, (String)String.format("mid:%s,productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", string, this.productId, this.product_secret, string2, string3, string4, string5, string6));
        return bl;
    }

    public boolean isValid() {
        boolean bl = true;
        if (TextUtils.isEmpty((CharSequence)this.mid)) {
            Trace.d((String)TAG, (String)"isValid() mid = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() productId = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.oem)) {
            Trace.d((String)TAG, (String)"isValid() oem = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.models)) {
            Trace.d((String)TAG, (String)"isValid() models = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.platform)) {
            Trace.d((String)TAG, (String)"isValid() platform = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceType)) {
            Trace.d((String)TAG, (String)"isValid() deviceType = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.product_secret)) {
            Trace.d((String)TAG, (String)"isValid() product_secret = null");
            bl = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() product id = null");
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "DeviceInfo{\nmid='" + this.mid + '\'' + "\n" + "oem=" + "'" + this.oem + '\'' + "\n" + "models=" + "'" + this.models + '\'' + "\n" + "platform=" + "'" + this.platform + '\'' + "\n" + "deviceType=" + "'" + this.deviceType + '\'' + "\n" + "product secret=" + "'" + this.product_secret + '\'' + "\n" + "product id=" + "'" + this.productId + '\'' + "\n" + '}';
    }
}

