/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Utils {
    public static int getNumCores() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Exception e) {
            return 4;
        }
    }

    public static String getAppVersionName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String versionName = "";
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static String mapToString(Map<String, String> map) {
        StringBuffer buffer = new StringBuffer();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            String key = next.getKey();
            String value = next.getValue();
            buffer.append(key).append("=").append(value);
            if (!iterator.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static void cleanCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            Utils.deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    public static String getCachePath(Context context) {
        String path = "";
        path = Environment.getExternalStorageState().equals("mounted") ? context.getExternalCacheDir().getAbsolutePath() : context.getCacheDir().getAbsolutePath();
        return path;
    }

    public static List<File> getCacheDownFile(Context context) {
        ArrayList<File> file_list = new ArrayList<File>();
        for (int i = 0; i < Utils.getNumCores() + 1; ++i) {
            File file = new File(Utils.getCachePath(context) + "/" + (i + 1) + ".txt");
            if (!file.exists() || file.length() <= 0L) continue;
            file_list.add(file);
        }
        return file_list;
    }

    public static boolean deletCacheDownFile(Context context) {
        List<File> cacheDownFile = Utils.getCacheDownFile(context);
        boolean delete = true;
        for (File file : cacheDownFile) {
            boolean del = file.delete();
            del = false;
            if (!false) continue;
            delete = false;
        }
        return delete;
    }

    public static boolean isNewtask(Context context) {
        List<File> cacheDownFile = Utils.getCacheDownFile(context);
        return cacheDownFile.size() <= 0;
    }

    private static void deleteFilesByDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            for (File item : directory.listFiles()) {
                item.delete();
            }
        }
    }

    public static String setFotaLog(Context context) {
        String path = Environment.getExternalStorageState().equals("mounted") ? (Build.VERSION.SDK_INT >= 23 ? context.getExternalCacheDir() + "/iport_log.txt" : Environment.getExternalStorageDirectory() + "/iport_log.txt") : context.getCacheDir().getAbsolutePath() + File.separator + "iport_log.txt";
        return path;
    }
}

