/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.content.Context;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import com.adups.trace.Trace;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class StorageUtil {
    public static final String ota_log_folder_name = "/otaLogs";
    private static final String TAG = "StorageUtil";

    public static String getOtaLogPath(Context context) {
        File file;
        String path = "";
        String removableStorage = StorageUtil.getStoragePath(context, true);
        if (!TextUtils.isEmpty((CharSequence)removableStorage)) {
            file = new File(removableStorage + ota_log_folder_name);
            if (file.exists()) {
                path = file.getAbsolutePath();
            }
        } else {
            File file2;
            String internalStorage = StorageUtil.getStoragePath(context, false);
            if (!TextUtils.isEmpty((CharSequence)internalStorage) && (file2 = new File(internalStorage + ota_log_folder_name)).exists()) {
                path = file2.getAbsolutePath();
            }
        }
        if (TextUtils.isEmpty((CharSequence)path) && (file = new File(Environment.getExternalStorageDirectory() + ota_log_folder_name)).exists()) {
            path = file.getAbsolutePath();
        }
        Trace.d((String)TAG, (String)("getOtaLogPath() path = " + path));
        return path;
    }

    public static String getStoragePath(Context mContext, boolean is_removable) {
        StorageManager mStorageManager = (StorageManager)mContext.getSystemService("storage");
        Class<?> storageVolumeClazz = null;
        try {
            storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
            Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
            Method isRemovable = storageVolumeClazz.getMethod("isRemovable", new Class[0]);
            Object result = getVolumeList.invoke((Object)mStorageManager, new Object[0]);
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String path = (String)getPath.invoke(storageVolumeElement, new Object[0]);
                boolean removable = (Boolean)isRemovable.invoke(storageVolumeElement, new Object[0]);
                if (is_removable != removable) continue;
                return path;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

