/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import com.adups.iot_libs.utils.FileUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.util.List;

public final class ShellUtils {
    private ShellUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static CommandResult execCmd(String command, boolean isRoot) {
        return ShellUtils.execCmd(new String[]{command}, isRoot, true);
    }

    public static CommandResult execCmd(List<String> commands, boolean isRoot) {
        return ShellUtils.execCmd(commands == null ? null : commands.toArray(new String[0]), isRoot, true);
    }

    public static CommandResult execCmd(String[] commands, boolean isRoot) {
        return ShellUtils.execCmd(commands, isRoot, true);
    }

    public static CommandResult execCmd(String command, boolean isRoot, boolean isNeedResultMsg) {
        return ShellUtils.execCmd(new String[]{command}, isRoot, isNeedResultMsg);
    }

    public static CommandResult execCmd(List<String> commands, boolean isRoot, boolean isNeedResultMsg) {
        return ShellUtils.execCmd(commands == null ? null : commands.toArray(new String[0]), isRoot, isNeedResultMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandResult execCmd(String[] commands, boolean isRoot, boolean isNeedResultMsg) {
        DataOutputStream os;
        StringBuilder errorMsg;
        StringBuilder successMsg;
        BufferedReader errorResult;
        BufferedReader successResult;
        Process process;
        int result;
        block11: {
            result = -1;
            if (commands == null || commands.length == 0) {
                return new CommandResult(result, null, null);
            }
            process = null;
            successResult = null;
            errorResult = null;
            successMsg = null;
            errorMsg = null;
            os = null;
            try {
                String s;
                process = Runtime.getRuntime().exec(isRoot ? "su" : "sh");
                os = new DataOutputStream(process.getOutputStream());
                for (String command : commands) {
                    if (command == null) continue;
                    os.write(command.getBytes());
                    os.writeBytes("\n");
                    os.flush();
                }
                os.writeBytes("exit\n");
                os.flush();
                result = process.waitFor();
                if (!isNeedResultMsg) break block11;
                successMsg = new StringBuilder();
                errorMsg = new StringBuilder();
                successResult = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
                while ((s = successResult.readLine()) != null) {
                    successMsg.append(s);
                }
                while ((s = errorResult.readLine()) != null) {
                    errorMsg.append(s);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.closeIO(os, successResult, errorResult);
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                FileUtil.closeIO(os, successResult, errorResult);
                if (process != null) {
                    process.destroy();
                }
            }
        }
        FileUtil.closeIO(os, successResult, errorResult);
        if (process != null) {
            process.destroy();
        }
        return new CommandResult(result, successMsg == null ? null : successMsg.toString(), errorMsg == null ? null : errorMsg.toString());
    }

    public static class CommandResult {
        public int result;
        public String successMsg;
        public String errorMsg;

        public CommandResult(int result, String successMsg, String errorMsg) {
            this.result = result;
            this.successMsg = successMsg;
            this.errorMsg = errorMsg;
        }
    }
}

