/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetUtils {
    public static final String NETWORN_NONE = "no";
    public static final String NETWORN_WIFI = "WIFI";
    public static final String NETWORN_2G = "2G";
    public static final String NETWORN_3G = "3G";
    public static final String NETWORN_4G = "4G";
    public static final String NETWORN_MOBILE = "mobile";

    public static String getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return NETWORN_NONE;
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return NETWORN_NONE;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return NETWORN_WIFI;
        }
        NetworkInfo networkInfo = connManager.getNetworkInfo(0);
        if (null != networkInfo) {
            NetworkInfo.State state2 = networkInfo.getState();
            String strSubTypeName = networkInfo.getSubtypeName();
            if (null != state2 && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                switch (activeNetInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return NETWORN_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return NETWORN_3G;
                    }
                    case 13: {
                        return NETWORN_4G;
                    }
                }
                if (strSubTypeName.equalsIgnoreCase("TD-SCDMA") || strSubTypeName.equalsIgnoreCase("WCDMA") || strSubTypeName.equalsIgnoreCase("CDMA2000")) {
                    return NETWORN_3G;
                }
                return NETWORN_MOBILE;
            }
        }
        return NETWORN_NONE;
    }

    public static String getHost(String deltaUrl) {
        if (deltaUrl.startsWith("https://")) {
            String substring = deltaUrl.substring("https://".length());
            return substring.substring(0, substring.indexOf("/"));
        }
        if (deltaUrl.startsWith("http://")) {
            String substring = deltaUrl.substring("http://".length());
            return substring.substring(0, substring.indexOf("/"));
        }
        return deltaUrl.substring(0, deltaUrl.indexOf("/"));
    }
}

