/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.content.Context;
import com.adups.iot_libs.info.PolicyMapInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.SafeInfo;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.iot_libs.utils.SPFTool;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonAnalyticsUtil {
    public static final int SUCCESS = 1000;

    public static boolean isSuccess(int status) {
        return status == 1000;
    }

    public static boolean responseSuccess(int i) {
        return i == 1000;
    }

    public static boolean reportJson(String jsonStr) {
        try {
            JSONObject jobj = new JSONObject(jsonStr);
            if (jobj.has("status")) {
                int status = jobj.getInt("status");
                return JsonAnalyticsUtil.isSuccess(status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static int registerJson(String json, Context sCx) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("status")) {
                int status = jsonObject.getInt("status");
                if (status == 1000) {
                    JsonAnalyticsUtil.setRegisterInfo(jsonObject, sCx);
                }
                return status;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return 2001;
    }

    public static int responseJson(String json) {
        try {
            JSONObject body;
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("body") && (body = jsonObject.getJSONObject("body")).has("status")) {
                int status = body.getInt("status");
                return status;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return 2002;
    }

    private static void setRegisterInfo(JSONObject json, Context sCx) throws JSONException {
        if (json.has("data")) {
            JSONObject data = json.getJSONObject("data");
            if (data.has("deviceSecret")) {
                String deviceSecret;
                RegisterInfo.getInstance().deviceSecret = deviceSecret = data.getString("deviceSecret");
                SPFTool.putString(sCx, "deviceSecret", deviceSecret);
            }
            if (data.has("deviceId")) {
                String deviceId;
                RegisterInfo.getInstance().deviceId = deviceId = data.getString("deviceId");
                SPFTool.putString(sCx, SPFTool.KEY_DEVICE_ID, deviceId);
            }
        }
    }

    public static int versionJson(Context context, String jsonStr) {
        try {
            JSONObject body = new JSONObject(jsonStr);
            if (body.has("status")) {
                int status = body.getInt("status");
                if (JsonAnalyticsUtil.isSuccess(status)) {
                    SPFTool.putString(context, SPFTool.KEY_NEW_VERSION_JSON, body.toString());
                    JsonAnalyticsUtil.setInfo(body);
                    return status;
                }
                SPFTool.putString(context, SPFTool.KEY_NEW_VERSION_JSON, "");
                return status;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 3003;
    }

    private static void setInfo(JSONObject jobj) throws JSONException {
        if (jobj.has("data")) {
            JSONObject data = jobj.getJSONObject("data");
            if (data.has("version")) {
                JSONObject verJob = new JSONObject(data.getString("version"));
                if (verJob.has("versionName")) {
                    VersionInfo.getInstance().versionName = verJob.getString("versionName");
                }
                if (verJob.has("fileSize")) {
                    VersionInfo.getInstance().fileSize = verJob.getInt("fileSize");
                }
                if (verJob.has("deltaID")) {
                    VersionInfo.getInstance().deltaID = verJob.getString("deltaID");
                }
                if (verJob.has("md5sum")) {
                    String tmpMd5 = verJob.getString("md5sum");
                    int fix_num = 32 - tmpMd5.length();
                    for (int i = 0; i < fix_num; ++i) {
                        tmpMd5 = "0" + tmpMd5;
                    }
                    VersionInfo.getInstance().md5sum = tmpMd5;
                }
                if (verJob.has("deltaUrl")) {
                    VersionInfo.getInstance().deltaUrl = verJob.getString("deltaUrl");
                }
            }
            if (data.has("releaseNotes")) {
                JSONObject relJob = new JSONObject(data.getString("releaseNotes"));
                if (relJob.has("version")) {
                    VersionInfo.getInstance().versionName = relJob.getString("version");
                }
                if (relJob.has("publishDate")) {
                    VersionInfo.getInstance().publishDate = relJob.getString("publishDate");
                }
                if (relJob.has("content")) {
                    VersionInfo.getInstance().content = relJob.getString("content");
                }
            }
            if (data.has("policy")) {
                String jsonData;
                JSONObject polJob = new JSONObject(data.getString("policy"));
                if (polJob.has("download")) {
                    jsonData = polJob.getString("download");
                    JsonAnalyticsUtil.getPolicyMapInfo(jsonData, "download");
                }
                if (polJob.has("install")) {
                    jsonData = polJob.getString("install");
                    JsonAnalyticsUtil.getPolicyMapInfo(jsonData, "install");
                }
                if (polJob.has("check")) {
                    jsonData = polJob.getString("check");
                    JsonAnalyticsUtil.getPolicyMapInfo(jsonData, "check");
                }
            }
            if (data.has("safe")) {
                JSONObject safeJob = new JSONObject(data.getString("safe"));
                if (safeJob.has("isEncrypt")) {
                    int isEncrypt;
                    SafeInfo.getInstance().isEncrypt = isEncrypt = safeJob.getInt("isEncrypt");
                }
                if (safeJob.has("encKey")) {
                    String encKey;
                    SafeInfo.getInstance().encKey = encKey = safeJob.getString("encKey");
                }
            }
        }
    }

    private static void getPolicyMapInfo(String jsonData, String keyTag) {
        try {
            JSONArray array = new JSONArray(jsonData);
            int len = array.length();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonPolicy = array.getJSONObject(i);
                PolicyMapInfo policyMapInfo = new PolicyMapInfo();
                if (jsonPolicy.has("key_name")) {
                    policyMapInfo.key_name = jsonPolicy.getString("key_name");
                }
                if (jsonPolicy.has("key_value")) {
                    policyMapInfo.key_value = jsonPolicy.getString("key_value");
                }
                if (jsonPolicy.has("key_message")) {
                    policyMapInfo.key_message = jsonPolicy.getString("key_message");
                }
                VersionInfo.getInstance().policyHashMap.put(keyTag + "_" + policyMapInfo.key_name, policyMapInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

