/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.text.TextUtils;
import com.adups.trace.Trace;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5ByFile(File file) {
        FileInputStream fis = null;
        StringBuffer buf = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            fis = new FileInputStream(file);
            byte[] buffer = new byte[262144];
            int length = -1;
            long s = System.currentTimeMillis();
            if (fis == null || md == null) {
                String string = null;
                return string;
            }
            while ((length = fis.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            byte[] bytes = md.digest();
            if (bytes == null) {
                String ex = null;
                return ex;
            }
            for (int i = 0; i < bytes.length; ++i) {
                String md5s = Integer.toHexString(bytes[i] & 0xFF);
                if (md5s == null || buf == null) {
                    String string = null;
                    return string;
                }
                if (md5s.length() == 1) {
                    buf.append("0");
                }
                buf.append(md5s);
            }
            String value = buf.toString();
            int fix_num = 32 - value.length();
            for (int i = 0; i < fix_num; ++i) {
                value = "0" + value;
            }
            String string = value;
            return string;
        }
        catch (Exception ex) {
            Trace.d((String)"FileUtil", (String)("getFileMD5, Exception " + ex.toString()));
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getMd5ByFile(String filePath) {
        File fd = new File(filePath);
        if (fd.exists()) {
            return FileUtil.getMd5ByFile(fd);
        }
        return "";
    }

    public static boolean validateFile(String filePath, String md5sum) {
        if (TextUtils.isEmpty((CharSequence)filePath) || TextUtils.isEmpty((CharSequence)md5sum)) {
            return false;
        }
        String md5_file = FileUtil.getMd5ByFile(filePath);
        Trace.i((String)"FileUtil", (String)("validateFile() " + md5sum.equals(md5_file) + "md5_file = " + md5_file + " md5_net = " + md5sum));
        return md5sum.equals(md5_file);
    }

    public static boolean createOrExistsDir(String dirPath) {
        if (FileUtil.isSpace(dirPath)) {
            return false;
        }
        File path = new File(dirPath);
        return path != null && (path.exists() ? path.isDirectory() : path.mkdirs());
    }

    public static void delDir(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            File[] tmp = dir.listFiles();
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isDirectory()) {
                    FileUtil.delDir(path + "/" + tmp[i].getName());
                    continue;
                }
                tmp[i].delete();
            }
            dir.delete();
        }
    }

    public static String convertFileSize(long size) {
        float result = size;
        String suffix = "B";
        if (result > 1024.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result > 1024.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result > 1024.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result > 1024.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        String roundFormat = result < 10.0f ? "%.2f" : (result < 100.0f ? "%.1f" : "%.0f");
        return String.format(roundFormat + suffix, Float.valueOf(result));
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

