/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.trace.Trace;
import java.io.File;

public class DownloadUtils {
    public static String getCachePath(Context context) {
        String path = "";
        path = Environment.getExternalStorageState().equals("mounted") ? context.getExternalCacheDir().getAbsolutePath() : context.getCacheDir().getAbsolutePath();
        return path;
    }

    public static File getCacheFile(Context context) {
        String deltaID = VersionInfo.getInstance().deltaID;
        if (TextUtils.isEmpty((CharSequence)deltaID)) {
            Trace.d((String)"DownloadUtils", (String)"deleteCacheFile() deltaId is null,please do check version!");
            return null;
        }
        String s = DownloadUtils.getCachePath(context) + File.separator + deltaID + ".txt";
        return new File(s);
    }

    public static void deleteCacheFile(Context context) {
        String deltaID = VersionInfo.getInstance().deltaID;
        if (TextUtils.isEmpty((CharSequence)deltaID)) {
            Trace.d((String)"DownloadUtils", (String)"deleteCacheFile() deltaId is null,please do check version!");
            return;
        }
        File file = new File(DownloadUtils.getCachePath(context) + File.separator + deltaID + ".txt");
        if (file.exists()) {
            boolean delete = file.delete();
            Trace.d((String)"DownloadUtils", (String)("deleteCacheFile(): " + delete));
        } else {
            Trace.d((String)"DownloadUtils", (String)"deleteCacheFile() file is not exist!");
        }
    }
}

