/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.adups.iot_libs.utils.ShellUtils;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class DeviceUtils {
    public static String getMacAddress(Context context) {
        String macAddress = DeviceUtils.getMacAddressByWifiInfo(context);
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByNetworkInterface();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtils.getMacAddressByFile();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getMacAddressByWifiInfo(Context context) {
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nis) {
                byte[] macBytes;
                if (!ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }
                return res1.deleteCharAt(res1.length() - 1).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = ShellUtils.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            result = ShellUtils.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && result.successMsg != null) {
                return result.successMsg;
            }
        }
        return "02:00:00:00:00:00";
    }
}

