/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.RecoverySystem;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.adups.iot_download_libs.DLManager;
import com.adups.iot_download_libs.DownEntity;
import com.adups.iot_download_libs.IOnDownListener;
import com.adups.iot_libs.MqttAgentPolicy;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.constant.Error;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.DownParamInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.iot_libs.inter.ICheckVersionCallback;
import com.adups.iot_libs.inter.IDownloadListener;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IRebootUpgradeCallBack;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.inter.OtaListener;
import com.adups.iot_libs.interact.HttpTools;
import com.adups.iot_libs.interact.OtaTools;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.utils.FileUtil;
import com.adups.iot_libs.utils.JsonAnalyticsUtil;
import com.adups.iot_libs.utils.NetUtils;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.trace.Trace;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class OtaService
extends IntentService {
    public static final String ACTION_REGISTER = "action_register";
    public static final String ACTION_CHECK_VERSION = "action_check_version";
    public static final String ACTION_CONNECT = "action_connect";
    public static final String ACTION_DISCONNECT = "action_disconnect";
    public static final String ACTION_DOWNLOAD = "action_download";
    public static final String ACTION_UPDATE = "action_update";
    public static final String ACTION_REPORT = "action_report";
    public static final String TAG = "OtaService";
    private static final String KEY_ACTION = "key_action";
    private static Context sCx;
    private static IDownloadListener sDownloadListener;
    private static ICheckVersionCallback sCheckVersionListener;
    private static IRegisterListener sRegisterListener;
    private static IRebootUpgradeCallBack sIRebootUpgradeCallBack;
    private static String local_update_path;
    private Handler handler;
    private static long mStartTime;
    private static boolean local_upgrade;
    private static String ip;

    public OtaService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.handler = new Handler();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        String action;
        if (intent == null) {
            return;
        }
        switch (action = intent.getStringExtra(KEY_ACTION)) {
            case "action_register": {
                this.register_task();
                break;
            }
            case "action_check_version": {
                this.check_version_task();
                break;
            }
            case "action_connect": {
                this.connectMqtt();
                break;
            }
            case "action_disconnect": {
                this.disConnectMqtt();
                break;
            }
            case "action_download": {
                this.download_task();
                break;
            }
            case "action_update": {
                if (local_upgrade) {
                    this.rebootLocalUpgrade();
                    break;
                }
                this.upgrade();
                break;
            }
            case "action_report": {
                this.task_report();
            }
        }
    }

    private void task_report() {
        ReportManager.getInstance(sCx).report();
    }

    private void upgrade() {
        Trace.d((String)TAG, (String)"upgrade() start.");
        if (null == sIRebootUpgradeCallBack) {
            Trace.e((String)TAG, (String)"upgrade() sIRebootUpgradeCallBack is null,please call method setUpdateCallBack()!");
            return;
        }
        String updatePath = OtaAgentPolicy.getPackagePath();
        Trace.d((String)TAG, (String)("rebootUpgrade() path:" + updatePath));
        if (!FileUtil.validateFile(updatePath, VersionInfo.getInstance().md5sum)) {
            Trace.e((String)TAG, (String)"onUpdateFail() . update validate file fail");
            this.onUpdateFailed(7005, "update validate file fail");
            this.saveUpdateFailedAndReport(7005);
            return;
        }
        this.startUpdate(new File(updatePath), sIRebootUpgradeCallBack);
    }

    public void rebootLocalUpgrade() {
        String updatePath = local_update_path;
        Trace.d((String)TAG, (String)("rebootLocalUpgrade() path:" + updatePath));
        if (sIRebootUpgradeCallBack == null) {
            Trace.e((String)TAG, (String)"rebootUpgrade() IRebootUpgradeCallBack is null");
            this.saveUpdateFailedAndReport(7005);
            return;
        }
        if (updatePath == null) {
            Trace.e((String)TAG, (String)"rebootLocalUpgrade() path is null");
            this.saveUpdateFailedAndReport(7005);
            return;
        }
        this.startUpdate(new File(updatePath), sIRebootUpgradeCallBack);
    }

    private void startUpdate(File file, IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        if (!file.exists() || file.length() == 0L) {
            Trace.e((String)TAG, (String)"onUpdateFail() .The updatePath file is not exist or file length is 0");
            this.onUpdateFailed(7002, "The updatePath file is not exist or file length is 0");
            this.saveUpdateFailedAndReport(7005);
            return;
        }
        SPFTool.putString(sCx, "key_update_file_path", file.getAbsolutePath());
        SPFTool.putString(sCx, "key_version_name", OtaAgentPolicy.getVersionInfo().versionName);
        SPFTool.putString(sCx, "KEY_DELTAID", OtaAgentPolicy.getVersionInfo().deltaID);
        Trace.d((String)TAG, (String)("rebootUpgrade() version_name = " + SPFTool.getString(sCx, "key_version_name", "null") + ",deltaId:" + SPFTool.getString(sCx, "KEY_DELTAID", "null")));
        try {
            RecoverySystem.installPackage((Context)sCx, (File)file);
        }
        catch (IOException e) {
            Trace.e((String)TAG, (String)"onUpdateFail() .", (Throwable)e);
            this.onUpdateFailed(7004, e.toString());
            this.saveUpdateFailedAndReport(7005);
        }
    }

    private void download_task() {
        if (null == sDownloadListener) {
            Trace.d((String)TAG, (String)"download_task(). downloadListener is null,please call method setDownloadListener();");
            return;
        }
        ReportManager.getInstance(sCx).report();
        mStartTime = System.currentTimeMillis();
        String down_path = OtaAgentPolicy.getPackagePath();
        DownEntity downEntity = new DownEntity(VersionInfo.getInstance().deltaUrl, down_path, VersionInfo.getInstance().fileSize, VersionInfo.getInstance().md5sum);
        DLManager.getInstance().add(downEntity);
        DLManager.getInstance().execAsync(new IOnDownListener(){

            public void on_start() {
                OtaService.this.onCallbackMainThread(1, 0L, 0L, 0);
                OtaService.this.getIp();
            }

            public void on_finished(List<DownEntity> list, List<DownEntity> list1) {
            }

            public void on_success(DownEntity downEntity) {
                Trace.d((String)OtaService.TAG, (String)("on_success() " + downEntity));
                OtaService.reportDownParamInfo(0);
                OtaService.this.onCallbackMainThread(4, 0L, 0L, 0);
            }

            public void on_failed(DownEntity downEntity) {
                Trace.d((String)OtaService.TAG, (String)("on_failed() " + downEntity));
                OtaService.this.onCallbackMainThread(5, 0L, 0L, downEntity.download_status);
                OtaService.reportDownParamInfo(downEntity.download_status);
            }

            public void on_manual_cancel() {
                OtaService.this.onCallbackMainThread(3, 0L, 0L, 0);
            }

            public void on_all_progress(int i, long l, long l1) {
            }

            public void on_progress(DownEntity downEntity, int i, long l, long l1) {
                OtaService.this.onCallbackMainThread(2, l, l1, 0);
            }
        });
    }

    private void check_version_task() {
        if (null == sCheckVersionListener) {
            Trace.e((String)TAG, (String)"check_version_task() checkVersionListener is null,please call method setCheckVersionListener()!");
            return;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.e((String)TAG, (String)"check_version_task() device info is invalid!");
            this.onCheckVersionFailed(3001);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceSecret) || TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceId)) {
            Trace.e((String)TAG, (String)"check_version_task() please register!");
            this.onCheckVersionFailed(2003);
            return;
        }
        String version = HttpTools.getInstance().checkVersion(DeviceInfo.getInstance(), sCx);
        if (TextUtils.isEmpty((CharSequence)version)) {
            Trace.e((String)TAG, (String)"check_version_task() json is null!");
            this.onCheckVersionFailed(3003);
            return;
        }
        int i = JsonAnalyticsUtil.versionJson(sCx, version);
        if (JsonAnalyticsUtil.isSuccess(i)) {
            this.onCheckVersionSuccess();
        } else {
            this.onCheckVersionFailed(i);
        }
    }

    private void disConnectMqtt() {
        Trace.d((String)TAG, (String)"disConnectMqtt() ");
        if (MqttAgentPolicy.isConnected()) {
            if (OtaTools.getInstance().getState() == OtaTools.State.Login) {
                OtaTools.getInstance().setState(OtaTools.State.Disconnecting);
                OtaTools.getInstance().logout(true, new ILogoutCallback(){

                    @Override
                    public void onLogoutSuccess() {
                        OtaTools.getInstance().disConnect(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
                    }

                    @Override
                    public void onLogoutFail(int error) {
                        OtaTools.getInstance().disConnect(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
                    }

                    @Override
                    public void onLogoutTimeout() {
                        OtaTools.getInstance().disConnect(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
                    }
                });
            } else {
                OtaTools.getInstance().setState(OtaTools.State.Disconnecting);
                OtaTools.getInstance().disConnect(OtaListener.getInstance().setAction(OtaListener.Action.DISCONNECT));
            }
        }
    }

    private void connectMqtt() {
        Trace.d((String)TAG, (String)"connectMqtt() ");
        if (TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceSecret) || TextUtils.isEmpty((CharSequence)RegisterInfo.getInstance().deviceId)) {
            Trace.e((String)TAG, (String)"connectMqtt() please register!");
            return;
        }
        OtaTools.getInstance().setState(OtaTools.State.Connecting);
        OtaTools.getInstance().connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startByAction(String action) {
        Class<OtaService> clazz = OtaService.class;
        synchronized (OtaService.class) {
            if (TextUtils.isEmpty((CharSequence)action)) {
                Trace.e((String)TAG, (String)"startByAction() action is null");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (null == sCx) {
                Trace.e((String)TAG, (String)"startByAction() context is null,should call initContext();");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Intent intent = new Intent();
            intent.putExtra(KEY_ACTION, action);
            intent.setClass(sCx, OtaService.class);
            sCx.startService(intent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void register_task() {
        if (null == sCx) {
            Trace.e((String)TAG, (String)"register_task() context is null,please call method initContext() in application!");
            return;
        }
        if (null == sRegisterListener) {
            Trace.e((String)TAG, (String)"register_task() failed. registerListener is null,please call method: setRegisterListener();");
            return;
        }
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.e((String)TAG, (String)"register_task() failed. device info is null");
            return;
        }
        String register = HttpTools.getInstance().doPostRegister(DeviceInfo.getInstance(), sCx);
        if (TextUtils.isEmpty((CharSequence)register)) {
            sRegisterListener.onFailed(3003);
            return;
        }
        int i = JsonAnalyticsUtil.registerJson(register, sCx);
        if (i == 1000) {
            sRegisterListener.onSuccess();
        } else {
            sRegisterListener.onFailed(i);
        }
    }

    public static void initContext(Context context) {
        sCx = context;
    }

    public static void setRegisterListener(IRegisterListener registerListener) {
        sRegisterListener = registerListener;
    }

    public static void setDownloadListener(IDownloadListener listener) {
        sDownloadListener = listener;
    }

    public static void setCheckVersionListener(ICheckVersionCallback listener) {
        sCheckVersionListener = listener;
    }

    public static void setUpdateCallBack(IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        sIRebootUpgradeCallBack = iRebootUpgradeCallBack;
        local_upgrade = false;
    }

    public static void setDownloadCancel() {
        DLManager.getInstance().cancel_all();
    }

    private void onCheckVersionSuccess() {
        Trace.d((String)TAG, (String)"=================onCheckVersionSuccess=================");
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                sCheckVersionListener.onCheckSuccess(VersionInfo.getInstance());
            }
        });
    }

    private void onCheckVersionFailed(final int error) {
        Trace.d((String)TAG, (String)("=================onCheckVersionFailed================= \n error:" + Error.getErrorMessage(error)));
        if (sCheckVersionListener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (sCheckVersionListener != null) {
                        sCheckVersionListener.onCheckFail(error);
                    }
                }
            });
        }
    }

    private void onUpdateFailed(final int error, final String msg) {
        Trace.e((String)TAG, (String)("=================onUpdateFailed=================\n error:" + error));
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (sIRebootUpgradeCallBack != null) {
                    sIRebootUpgradeCallBack.onError(error, msg);
                }
            }
        });
    }

    public static void reportDownParamInfo(int code) {
        int length;
        int downCode;
        switch (code) {
            case 0: {
                downCode = 1;
                break;
            }
            case -1: {
                downCode = 8;
                break;
            }
            case -2: {
                downCode = 7;
                break;
            }
            default: {
                downCode = 99;
            }
        }
        try {
            length = (int)new File(OtaAgentPolicy.getPackagePath()).length();
        }
        catch (Exception e) {
            length = 0;
        }
        DownParamInfo downParamInfo = new DownParamInfo(OtaAgentPolicy.getVersionInfo().deltaID, String.valueOf(downCode), mStartTime, System.currentTimeMillis(), length, ip);
        ReportManager.getInstance(sCx).saveReportData(downParamInfo);
        ReportManager.getInstance(sCx).report();
    }

    public static void setLocalUpgrade(String path) {
        local_update_path = path;
        local_upgrade = true;
    }

    private void saveUpdateFailedAndReport(int error) {
        int error_status = 99;
        switch (error) {
            case 7003: {
                error_status = 2;
                break;
            }
            case 7004: {
                error_status = 3;
                break;
            }
            case 7002: {
                error_status = 4;
                break;
            }
            default: {
                error_status = 5;
            }
        }
        UpgradeParamInfo info = new UpgradeParamInfo(DeviceInfo.getInstance().mid, VersionInfo.getInstance().deltaID, String.valueOf(error_status));
        ReportManager.getInstance(sCx).saveReportData(info);
        this.task_report();
    }

    public void onCallbackMainThread(final int i, final long downSize, final long totalSize, final int errorCode) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                switch (i) {
                    case 1: {
                        sDownloadListener.onPrepare();
                        break;
                    }
                    case 2: {
                        sDownloadListener.onDownloadProgress(downSize, totalSize);
                        break;
                    }
                    case 3: {
                        sDownloadListener.onCancel();
                        break;
                    }
                    case 4: {
                        sDownloadListener.onCompleted();
                        break;
                    }
                    case 5: {
                        sDownloadListener.onFailed(errorCode);
                    }
                }
            }
        });
    }

    private void getIp() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                InetAddress address = null;
                try {
                    address = InetAddress.getByName(NetUtils.getHost(VersionInfo.getInstance().deltaUrl));
                    ip = address.getHostAddress();
                    Trace.d((String)OtaService.TAG, (String)("download_task() download IP:" + ip));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    static {
        local_upgrade = false;
        ip = "";
    }
}

