/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.security;

public class FotaException
extends Exception {
    public static final int REASON_CODE_CLIENT_ERROR = 0;
    public static final int REASON_CODE_MANIFEST_NOT_REGISTER = 201;
    public static final int REASON_CODE_DEVICE_PARAMETERS = 202;
    public static final int REASON_CODE_MANIFEST_META_DATA_ERROR = 203;
    public static final int REASON_CODE_CREATE_DOWNLOAD_PATH_FAILED = 204;
    private int reasonCode;
    private Throwable cause;

    public FotaException(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public FotaException(Throwable cause) {
        this.reasonCode = 0;
        this.cause = cause;
    }

    public FotaException(int reason, Throwable cause) {
        this.reasonCode = reason;
        this.cause = cause;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(this.reasonCode);
    }

    @Override
    public String toString() {
        String result = this.getMessage() + " (" + this.reasonCode + ")";
        if (this.cause != null) {
            result = result + " - " + this.cause.toString();
        }
        return result;
    }

    private String getErrorMessage(int reasonCode) {
        switch (reasonCode) {
            case 201: {
                return "AndroidManifest element and permissions is lack";
            }
            case 202: {
                return "Fota [DeviceInfo] initPackagePath device parameters exception";
            }
            case 203: {
                return "AndroidManifest meta-data is null or should start with string/";
            }
        }
        return "UnExpect Exception";
    }
}

