/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.report;

import android.content.Context;
import android.text.TextUtils;
import com.adups.iot_libs.info.DownParamInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.inter.IReportResultCallback;
import com.adups.iot_libs.interact.HttpTools;
import com.adups.iot_libs.report.ReportDBManager;
import com.adups.iot_libs.utils.JsonAnalyticsUtil;
import com.adups.iot_libs.utils.StorageUtil;
import com.adups.trace.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ReportManager {
    private static String TAG = "ReportManager";
    private static ReportManager m_instance;
    private final Context m_context;
    private final ReportDBManager m_dbManager;

    private ReportManager(Context context) {
        this.m_context = context.getApplicationContext();
        this.m_dbManager = new ReportDBManager(this.m_context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportManager getInstance(Context context) {
        if (m_instance != null) return m_instance;
        Class<ReportManager> clazz = ReportManager.class;
        synchronized (ReportManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new ReportManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_instance;
        }
    }

    public int queryReport() {
        List<UpgradeParamInfo> upgradeParamInfos = this.m_dbManager.query_upgrade();
        List<DownParamInfo> downInfos = this.m_dbManager.query_down();
        return upgradeParamInfos.size() + downInfos.size();
    }

    public void saveReportData(Object reportData) {
        if (reportData instanceof UpgradeParamInfo) {
            this.m_dbManager.add((UpgradeParamInfo)reportData);
        } else if (reportData instanceof DownParamInfo) {
            this.m_dbManager.add((DownParamInfo)reportData);
        }
    }

    public void report() {
        Trace.d((String)TAG, (String)"----------report--------");
        List<DownParamInfo> downInfos = this.m_dbManager.query_down();
        int size = downInfos.size();
        Trace.d((String)TAG, (String)("check the local report download: " + size));
        for (final DownParamInfo info : downInfos) {
            this.reportDown(info, new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    ReportManager.this.m_dbManager.delete(info);
                }

                @Override
                public void onReportFail() {
                    ReportManager.this.m_dbManager.delete(info);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() .");
                }
            });
        }
        List<UpgradeParamInfo> upgradeInfos = this.m_dbManager.query_upgrade();
        size = upgradeInfos.size();
        Trace.d((String)TAG, (String)("check the local report upgrade: " + size));
        for (final UpgradeParamInfo info : upgradeInfos) {
            this.reportUpgrade(info, new IReportResultCallback(){

                @Override
                public void onReportSuccess() {
                    Trace.d((String)TAG, (String)"onReportSuccess() upgrade");
                    ReportManager.this.m_dbManager.delete(info);
                }

                @Override
                public void onReportFail() {
                    Trace.d((String)TAG, (String)"onReportFail() upgrade.");
                    ReportManager.this.m_dbManager.delete(info);
                }

                @Override
                public void onReportNetFail() {
                    Trace.d((String)TAG, (String)"onReportNetFail() .");
                }
            });
        }
    }

    public void reportDown(DownParamInfo downParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String jsonStr = HttpTools.getInstance().doPostReportDownResult(downParamInfo);
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                iReportResultCallback.onReportNetFail();
            } else {
                boolean reportJson = JsonAnalyticsUtil.reportJson(jsonStr);
                if (reportJson) {
                    iReportResultCallback.onReportSuccess();
                } else {
                    iReportResultCallback.onReportFail();
                }
            }
        }
        catch (Exception e) {
            iReportResultCallback.onReportFail();
            e.printStackTrace();
        }
    }

    public void reportUpgrade(UpgradeParamInfo upgradeParamInfo, IReportResultCallback iReportResultCallback) {
        try {
            String jsonStr = HttpTools.getInstance().doPostUpgradeResult(upgradeParamInfo);
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                iReportResultCallback.onReportNetFail();
            } else {
                boolean reportJson = JsonAnalyticsUtil.reportJson(jsonStr);
                if (reportJson) {
                    iReportResultCallback.onReportSuccess();
                } else {
                    iReportResultCallback.onReportFail();
                }
            }
        }
        catch (Exception e) {
            iReportResultCallback.onReportFail();
            e.printStackTrace();
        }
    }

    public String getLogFile() {
        Trace.d((String)TAG, (String)"getLogFile() ");
        String destFilePath = this.m_context.getExternalCacheDir() + "/otaLogs" + ".zip";
        new File(destFilePath).delete();
        String folder = StorageUtil.getOtaLogPath(this.m_context);
        if (!TextUtils.isEmpty((CharSequence)folder)) {
            Trace.d((String)TAG, (String)("getLogFile() folder = " + folder));
            try {
                File[] files = new File(folder).listFiles();
                int max = Math.min(files.length, 5);
                CheckedOutputStream cos = new CheckedOutputStream(new BufferedOutputStream(new FileOutputStream(destFilePath)), new CRC32());
                ZipOutputStream zos = new ZipOutputStream(cos);
                int i = 0;
                if (i < max) {
                    int count;
                    File srcFile = files[i];
                    Trace.d((String)TAG, (String)("getLogFile() file path = " + srcFile.getAbsolutePath()));
                    ZipEntry entry = new ZipEntry(srcFile.getName());
                    zos.putNextEntry(entry);
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile));
                    byte[] data = new byte[8192];
                    while ((count = bis.read(data, 0, 8192)) != -1) {
                        zos.write(data, 0, count);
                    }
                    bis.close();
                    Trace.d((String)TAG, (String)"getLogFile() closeEntry");
                    zos.closeEntry();
                    zos.finish();
                    zos.close();
                    Trace.d((String)TAG, (String)"getLogFile() close");
                    return destFilePath;
                }
            }
            catch (Exception e) {
                Trace.d((String)TAG, (String)("getLogFile() " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return null;
    }
}

