/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.report;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.adups.iot_libs.info.DownParamInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.report.DBHelper;
import java.util.ArrayList;
import java.util.List;

public class ReportDBManager {
    private DBHelper helper;
    private SQLiteDatabase db;

    public ReportDBManager(Context context) {
        this.helper = new DBHelper(context);
        this.db = this.helper.getWritableDatabase();
    }

    public void add(DownParamInfo info) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("INSERT INTO report_down VALUES(null, ?, ?, ?, ?,?,?)", new Object[]{info.deltaID, info.downloadStatus, info.downStart, info.downEnd, info.downSize, info.downIp});
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public void add(UpgradeParamInfo info) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("INSERT INTO report_upgrade VALUES(null, ?, ?)", new Object[]{info.deltaID, info.updateStatus});
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public void delete(DownParamInfo info) {
        this.db.delete("report_down", "down_start_time = ?", new String[]{String.valueOf(info.downStart)});
    }

    public void delete(UpgradeParamInfo info) {
        this.db.delete("report_upgrade", "_id = ?", new String[]{String.valueOf(info._id)});
    }

    public List<DownParamInfo> query_down() {
        ArrayList<DownParamInfo> infos = new ArrayList<DownParamInfo>();
        Cursor c = this.queryByTableName("report_down");
        while (c != null && c.moveToNext()) {
            DownParamInfo info = new DownParamInfo();
            info._id = c.getInt(c.getColumnIndex("_id"));
            info.deltaID = c.getString(c.getColumnIndex("delta_id"));
            info.downloadStatus = c.getString(c.getColumnIndex("download_status"));
            info.downStart = c.getString(c.getColumnIndex("down_start_time"));
            info.downEnd = c.getString(c.getColumnIndex("down_end_time"));
            info.downSize = c.getInt(c.getColumnIndex("down_size"));
            info.downIp = c.getString(c.getColumnIndex("down_ip"));
            infos.add(info);
        }
        c.close();
        return infos;
    }

    public List<UpgradeParamInfo> query_upgrade() {
        ArrayList<UpgradeParamInfo> infos = new ArrayList<UpgradeParamInfo>();
        Cursor c = this.queryByTableName("report_upgrade");
        while (c != null && c.moveToNext()) {
            UpgradeParamInfo info = new UpgradeParamInfo();
            info._id = c.getInt(c.getColumnIndex("_id"));
            info.deltaID = c.getString(c.getColumnIndex("delta_id"));
            info.updateStatus = c.getString(c.getColumnIndex("updateStatus"));
            infos.add(info);
        }
        c.close();
        return infos;
    }

    private Cursor queryByTableName(String table_name) {
        Cursor c = this.db.rawQuery("SELECT * FROM " + table_name, null);
        return c;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }
}

