/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.receiver;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.service.JobSchedulerService;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.trace.Trace;
import java.io.File;

public class UpgradeReceiver
extends BroadcastReceiver {
    private static final String TAG = "UpgradeReceiver";
    private Context mCtx;

    public void onReceive(Context context, Intent intent) {
        this.mCtx = context;
        String action = intent.getAction();
        Trace.d((String)TAG, (String)("action: " + action));
        this.dispatch_action(action);
    }

    private void dispatch_action(String action) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            this.network_process();
        } else if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
            this.boot_process();
        }
    }

    private void boot_process() {
        SPFTool.putBoolean(this.mCtx, "key_should_report", true);
        String version_name = SPFTool.getString(this.mCtx, "key_version_name", "");
        String deltaId = SPFTool.getString(this.mCtx, "KEY_DELTAID", "");
        if (!TextUtils.isEmpty((CharSequence)version_name) && !TextUtils.isEmpty((CharSequence)deltaId)) {
            SPFTool.putString(this.mCtx, "key_version_name", "");
            SPFTool.putString(this.mCtx, "KEY_DELTAID", "");
            Trace.i((String)TAG, (String)("mobile version:" + DeviceInfo.getInstance().version + " update version " + version_name));
            boolean is_success = version_name.equals(DeviceInfo.getInstance().version);
            Intent intent = new Intent("action_fota_update_result");
            intent.putExtra("key_fota_update_result", is_success);
            LocalBroadcastManager.getInstance((Context)this.mCtx).sendBroadcast(intent);
            if (is_success) {
                Trace.d((String)TAG, (String)"boot_process() update success!");
                String path = SPFTool.getString(this.mCtx, "key_update_file_path", "");
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    new File(path).delete();
                }
            } else {
                Trace.d((String)TAG, (String)"boot_process() update failed!");
            }
            UpgradeParamInfo info = new UpgradeParamInfo(DeviceInfo.getInstance().mid, deltaId, String.valueOf(is_success ? 1 : 99));
            ReportManager.getInstance(this.mCtx).saveReportData(info);
            if (this.isNetWorkAvailable(this.mCtx)) {
                Trace.d((String)TAG, (String)"boot_process() boot complete upgrade report");
                this.report();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.startJobService();
            }
        }
    }

    @RequiresApi(api=21)
    private void startJobService() {
        Intent startServiceIntent = new Intent(this.mCtx, JobSchedulerService.class);
        this.mCtx.startService(startServiceIntent);
        ComponentName componentName = new ComponentName(this.mCtx, JobSchedulerService.class);
        JobInfo.Builder builder = new JobInfo.Builder(0, componentName);
        builder.setMinimumLatency(1000L);
        builder.setRequiredNetworkType(1);
        JobScheduler tm = (JobScheduler)this.mCtx.getSystemService("jobscheduler");
        tm.schedule(builder.build());
    }

    private void network_process() {
        if (this.isNetWorkAvailable(this.mCtx)) {
            Trace.d((String)TAG, (String)("network_process() should_report = " + SPFTool.getBoolean(this.mCtx, "key_should_report", false)));
            if (SPFTool.getBoolean(this.mCtx, "key_should_report", false)) {
                this.report();
            }
            String device_secret = SPFTool.getString(this.mCtx, "deviceSecret", "");
            String deviceId = SPFTool.getString(this.mCtx, SPFTool.KEY_DEVICE_ID, "");
            if (TextUtils.isEmpty((CharSequence)device_secret) || TextUtils.isEmpty((CharSequence)deviceId)) {
                OtaAgentPolicy.register(new IRegisterListener(){

                    @Override
                    public void onSuccess() {
                        Trace.d((String)UpgradeReceiver.TAG, (String)"network_process() register success ");
                    }

                    @Override
                    public void onFailed(int error) {
                        Trace.w((String)UpgradeReceiver.TAG, (String)"network_process() register fail ");
                    }
                });
            }
        }
    }

    private void report() {
        if (ReportManager.getInstance(this.mCtx).queryReport() == 0) {
            SPFTool.putBoolean(this.mCtx, "key_should_report", false);
            Trace.d((String)TAG, (String)"report() do not have data to be reported!");
            return;
        }
        OtaService.startByAction("action_report");
    }

    private boolean isNetWorkAvailable(Context context) {
        boolean ret = false;
        if (context == null) {
            return ret;
        }
        try {
            ConnectivityManager connectManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectManager == null) {
                return ret;
            }
            NetworkInfo[] infos = connectManager.getAllNetworkInfo();
            if (infos == null) {
                return ret;
            }
            for (int i = 0; i < infos.length && infos[i] != null; ++i) {
                if (!infos[i].isConnected() || !infos[i].isAvailable()) continue;
                ret = true;
                break;
            }
        }
        catch (Exception e) {
            Trace.d((String)TAG, (String)"==Util:isNetWorkAvailable Exception");
        }
        return ret;
    }
}

