/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.interact;

import android.text.TextUtils;
import com.adups.iot_libs.constant.SDKConfig;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.inter.ILoginCallback;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IReportDeviceStatusCallback;
import com.adups.iot_libs.inter.MessageListener;
import com.adups.iot_libs.inter.OtaListener;
import com.adups.mqtt_libs.connect.ConnectCommand;
import com.adups.mqtt_libs.connect.DisconnectCommand;
import com.adups.mqtt_libs.connect.MqttManager;
import com.adups.mqtt_libs.connect.PubCommand;
import com.adups.mqtt_libs.connect.SubCommand;
import com.adups.mqtt_libs.mqtt_service.MqttAndroidClient;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.trace.Trace;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class OtaTools {
    private static OtaTools mqttTools;
    private static final String TAG = "OtaTools";
    public Map<Integer, String> reply = new HashMap<Integer, String>();
    private MqttAndroidClient client;
    private MessageListener messageListener = MessageListener.getInstance();
    private State currentState = State.Null;

    private OtaTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OtaTools getInstance() {
        if (mqttTools != null) return mqttTools;
        Class<OtaTools> clazz = OtaTools.class;
        synchronized (OtaTools.class) {
            if (mqttTools != null) return mqttTools;
            mqttTools = new OtaTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mqttTools;
        }
    }

    public State getState() {
        return this.currentState;
    }

    public void setState(State state) {
        this.currentState = state;
    }

    public boolean verifyReplyByNo(int messageType, String replyno) {
        String s = this.reply.get(messageType);
        if (TextUtils.equals((CharSequence)replyno, (CharSequence)s)) {
            this.reply.remove(messageType);
            return true;
        }
        return false;
    }

    public void connect() {
        MqttManager mqttManager = MqttManager.getInstance();
        String username = DeviceInfo.getInstance().productId + "/" + RegisterInfo.getInstance().deviceId;
        String password = RegisterInfo.getInstance().deviceSecret;
        Trace.d((String)TAG, (String)("connect() " + username + "," + password));
        ConnectCommand connectCommand = ConnectCommand.getInstance().setClientId(DeviceInfo.getInstance().mid).setServer(SDKConfig.MQTT_HOST).setPort(1884).setTimeout(10).setKeepAlive(20).setLastWill(this.createLastWill(), String.format("product/%s/%s/logout", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId), 1, false).setCleanSession(false).setSsl("/assets/adcom.bks", "123456b").setUserNameAndPassword(username, password);
        try {
            mqttManager.connect(connectCommand, (IMqttActionListener)OtaListener.getInstance().setAction(OtaListener.Action.CONNECT));
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    private String createLastWill() {
        JSONObject last_will = new JSONObject();
        JSONObject body = new JSONObject();
        try {
            body.put("type", 2);
            last_will.put("seqno", (Object)this.seqnoCreate());
            last_will.put("body", (Object)body);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return last_will.toString();
    }

    public void disConnect(IMqttActionListener listener) {
        DisconnectCommand disconnectCommand = new DisconnectCommand();
        try {
            MqttManager.getInstance().disConnect(disconnectCommand, listener);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void disConnect(IMqttActionListener listener, long quiesceTimeout) {
        DisconnectCommand disconnectCommand = new DisconnectCommand().setQuiesceTimeout(quiesceTimeout);
        try {
            MqttManager.getInstance().disConnect(disconnectCommand, listener);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void setLoginListener(ILoginCallback listener) {
        if (null == this.messageListener) {
            Trace.e((String)TAG, (String)"setLoginListener() messageListener is null");
            return;
        }
        this.messageListener.setLoginListener(listener);
    }

    public void setLogoutListener(ILogoutCallback listener) {
        if (null == this.messageListener) {
            Trace.e((String)TAG, (String)"setLoginListener() messageListener is null");
            return;
        }
        this.messageListener.setLogoutListener(listener);
    }

    public void setReportDeviceStatusListener(IReportDeviceStatusCallback callback) {
        if (null == this.messageListener) {
            Trace.e((String)TAG, (String)"setReportDeviceStatusListener() messageListener is null");
            return;
        }
        this.messageListener.setReportDeviceStatusListener(callback);
    }

    public void reportDeviceInfo(String message, IReportDeviceStatusCallback callback) {
        JSONObject jsonObject;
        Trace.d((String)TAG, (String)"reportDeviceInfo() start.");
        this.setReportDeviceStatusListener(callback);
        String seqnoCreate = this.seqnoCreate();
        try {
            JSONObject reported = new JSONObject(message);
            jsonObject = new JSONObject();
            JSONObject body = new JSONObject();
            body.put("firewareVersion", (Object)DeviceInfo.getInstance().version);
            body.put("reported", (Object)reported);
            jsonObject.put("seqno", (Object)seqnoCreate);
            jsonObject.put("body", (Object)body);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Trace.e((String)TAG, (String)("reportDeviceInfo() JsonException:" + e.toString()));
            Trace.e((String)TAG, (String)"reportDeviceInfo() \u8bf7\u786e\u8ba4\u4f20\u5165\u7684\u6d88\u606f\u7b26\u5408json\u683c\u5f0f");
            return;
        }
        String topic = String.format("product/%s/%s/shadow/update", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.pub(topic, jsonObject.toString(), 1, false, OtaListener.getInstance().setAction(OtaListener.Action.PUB_REPORT_DEVICEINFO));
        this.reply.put(1002, seqnoCreate);
    }

    public void reportDeviceInfo(IReportDeviceStatusCallback callback) {
        this.reportDeviceInfo("{}", callback);
    }

    public void pubMsgPushResponse(String msgId, String replyno) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("seqno", (Object)this.seqnoCreate());
            jsonObject.put("replyno", (Object)replyno);
            JSONObject body = new JSONObject();
            body.put("msgId", (Object)msgId);
            body.put("timestamp", System.currentTimeMillis());
            jsonObject.put("body", (Object)body);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String topic = String.format("product/%s/%s/notify/response", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.pub(topic, jsonObject.toString(), 1, false, OtaListener.getInstance().setAction(OtaListener.Action.PUB_MSG_PUSH_RESPONSE));
    }

    public void subReportDeviceInfo() {
        String topic = String.format("product/%s/%s/shadow/update/response", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.sub(topic, 1, OtaListener.getInstance().setAction(OtaListener.Action.SUB_REPORT_DEVICEINFO));
    }

    public void login(ILoginCallback listener) {
        Trace.d((String)TAG, (String)"login() start");
        if (!DeviceInfo.getInstance().isValid()) {
            Trace.e((String)TAG, (String)"login() device info is null");
            return;
        }
        this.setLoginListener(listener);
        String topic = String.format("product/%s/%s/login", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        JSONObject body = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        String current_time = String.valueOf(System.currentTimeMillis());
        String seqno = this.seqnoCreate();
        try {
            body.put("timestamp", (Object)current_time);
            body.put("sign", (Object)(DeviceInfo.getInstance().productId + current_time));
            jsonObject.put("body", (Object)body);
            jsonObject.put("seqno", (Object)seqno);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.pub(topic, jsonObject.toString(), 1, false, OtaListener.getInstance().setAction(OtaListener.Action.PUB_LOGIN));
        this.reply.put(1000, seqno);
    }

    public void logout(boolean initiative, ILogoutCallback listener) {
        Trace.d((String)TAG, (String)"logout() start.");
        this.setLogoutListener(listener);
        String topic = String.format("product/%s/%s/logout", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        JSONObject object = new JSONObject();
        String seqno = this.seqnoCreate();
        try {
            object.put("seqno", (Object)seqno);
            JSONObject body = new JSONObject();
            body.put("type", initiative ? 1 : 2);
            object.put("body", (Object)body);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.pub(topic, object.toString(), 1, false, OtaListener.getInstance().setAction(OtaListener.Action.PUB_LOGOUT));
        if (initiative) {
            this.reply.put(1001, seqno);
        }
    }

    public void pub(String topic, String message, int qos, boolean retained, IMqttActionListener listener) {
        Trace.d((String)TAG, (String)("pub() topic:" + topic + "\n" + "message:" + message));
        PubCommand pubCommand = new PubCommand().setTopic(topic).setQos(qos).setMessage(message).setRetained(retained);
        try {
            MqttManager.getInstance().pub(pubCommand, listener);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subLogin() {
        Trace.d((String)TAG, (String)"subLogin() ");
        String topic = String.format("product/%s/%s/login/response", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.sub(topic, 1, OtaListener.getInstance().setAction(OtaListener.Action.SUB_LOGIN));
    }

    public void subLogout() {
        Trace.d((String)TAG, (String)"subLogout() ");
        String topic = String.format("product/%s/%s/logout/response", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.sub(topic, 1, OtaListener.getInstance().setAction(OtaListener.Action.SUB_LOGOUT));
    }

    public void subNotify() {
        Trace.d((String)TAG, (String)"subNotify() start.");
        String topic = String.format("product/%s/%s/notify", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        this.sub(topic, 1, OtaListener.getInstance().setAction(OtaListener.Action.SUB_NOTIFY));
    }

    public void sub(String topic, int qos, IMqttActionListener listener) {
        Trace.d((String)TAG, (String)("sub() start.topic:" + topic));
        SubCommand subCommand = new SubCommand().setQos(qos).setTopic(topic);
        try {
            MqttManager.getInstance().sub(subCommand, listener);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public String seqnoCreate() {
        StringBuffer buffer = new StringBuffer();
        long timeMillis = System.currentTimeMillis();
        buffer.append("D_").append(RegisterInfo.getInstance().deviceId).append(timeMillis);
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            int nextInt = random.nextInt(10);
            buffer.append(nextInt);
        }
        return buffer.toString();
    }

    public static enum State {
        Null,
        Connecting,
        Connected,
        Login,
        Logout,
        Disconnecting,
        Disconnected;

    }
}

