/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.interact;

import android.content.Context;
import android.text.TextUtils;
import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.RequestConfig;
import com.adups.http_libs.request.AbstractRequest;
import com.adups.http_libs.request.StringRequest;
import com.adups.http_libs.response.InternalResponse;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.constant.SDKConfig;
import com.adups.iot_libs.engine.TelephoneManager;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.DownParamInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.security.Codec2;
import com.adups.iot_libs.utils.DeviceUtils;
import com.adups.iot_libs.utils.MyHostnameVerifier;
import com.adups.iot_libs.utils.NetUtils;
import com.adups.iot_libs.utils.Utils;
import com.adups.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpTools {
    private static final String TAG = "HttpTools";
    private static final int CONNECT_TIME_OUT = 5000;
    private static final int READ_TIME_OUT = 5000;
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static HttpTools httpTools;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpTools getInstance() {
        if (httpTools != null) return httpTools;
        Class<HttpTools> clazz = HttpTools.class;
        synchronized (HttpTools.class) {
            if (httpTools != null) return httpTools;
            httpTools = new HttpTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpTools;
        }
    }

    public KeyStore getKeyStore(String password, String keyPath) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = KeyStore.getInstance("BKS");
        InputStream keyin = this.getClass().getResourceAsStream(keyPath);
        ks.load(keyin, password.toCharArray());
        keyin.close();
        return ks;
    }

    public SSLContext getSSLContext(String password, String keyStorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = this.getKeyStore(password, keyStorePath);
        keyManagerFactory.init(keyStore, password.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    public void initHttpsURLConnection(String password, String keyStorePath) throws Exception {
        SSLContext sslContext = null;
        MyHostnameVerifier hnv = new MyHostnameVerifier();
        try {
            sslContext = this.getSSLContext(password, keyStorePath);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hnv);
    }

    public String doPostRegister(DeviceInfo deviceInfo, Context context) {
        String appVersion = Utils.getAppVersionName(context);
        String networkState = NetUtils.getNetworkState(context);
        String url = SDKConfig.HTTP_BASE_URL + "/register/" + deviceInfo.productId;
        JSONObject jsonObject = new JSONObject();
        try {
            String macAddress = DeviceUtils.getMacAddress(context);
            jsonObject.put("mid", (Object)deviceInfo.mid);
            jsonObject.put("oem", (Object)deviceInfo.oem);
            jsonObject.put("models", (Object)deviceInfo.models);
            jsonObject.put("platform", (Object)deviceInfo.platform);
            jsonObject.put("deviceType", (Object)deviceInfo.deviceType);
            jsonObject.put("sdkversion", (Object)"1.0.9");
            if (!TextUtils.isEmpty((CharSequence)appVersion)) {
                jsonObject.put("appversion", (Object)appVersion);
            }
            jsonObject.put("version", (Object)deviceInfo.version);
            if (!TextUtils.isEmpty((CharSequence)macAddress)) {
                jsonObject.put("mac", (Object)macAddress);
            }
            if (!TextUtils.isEmpty((CharSequence)networkState)) {
                jsonObject.put("networkType", (Object)networkState);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Trace.d((String)TAG, (String)("doPostRegister() :" + e.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Trace.d((String)TAG, (String)("doPostRegister() :" + e.toString()));
        }
        InternalResponse response = HttpTools.doPostJson(url, jsonObject);
        String result = response.isResultOk() ? response.getResult().getMessage() : "";
        return result;
    }

    private static InternalResponse doPostJson(String baseUrl, JSONObject json) {
        Trace.d((String)TAG, (String)("doPostJson() request: url:" + baseUrl + " ,json:" + json.toString()));
        json = HttpTools.getSignAndTime(json, baseUrl);
        AbstractRequest request = new StringRequest(baseUrl).setMethod(HttpMethods.Post).setContent(json.toString().getBytes()).setHeaderContentType(RequestConfig.ContentType.TYPE_JSON);
        InternalResponse response = OtaAgentPolicy.httpManager.execute(request);
        Trace.d((String)TAG, (String)"doPostJson() response: result:%s", (Object[])new Object[]{response.isResultOk() ? response.getResult().getMessage() : "null"});
        return response;
    }

    private static JSONObject getSignAndTime(JSONObject json, String baseUrl) {
        long timestamp = System.currentTimeMillis();
        DeviceInfo deviceInfo = DeviceInfo.getInstance();
        String sign = baseUrl.contains("register") ? Codec2.getHmacMd5Str(deviceInfo.mid + deviceInfo.productId + timestamp, deviceInfo.product_secret) : Codec2.getHmacMd5Str(RegisterInfo.getInstance().deviceId + deviceInfo.productId + timestamp, RegisterInfo.getInstance().deviceSecret);
        try {
            json.put("timestamp", timestamp);
            if (!baseUrl.contains("notify/response")) {
                json.put("sign", (Object)sign);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Trace.e((String)TAG, (String)("getSignAndTime() " + e.toString()));
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String baseUrl, Map<String, String> params) {
        Trace.d((String)TAG, (String)("doPost() url:" + baseUrl));
        String result = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(baseUrl);
            if (null != url) {
                connection = (HttpsURLConnection)url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                byte[] data = HttpTools.getParamsData(params);
                connection.setRequestProperty(HEADER_CONTENT_TYPE, HttpTools.getBodyContentType());
                if (null != data) {
                    connection.setFixedLengthStreamingMode(data.length);
                    connection.setRequestProperty(HEADER_CONTENT_LENGTH, String.valueOf(data.length));
                    OutputStream outputStream = connection.getOutputStream();
                    outputStream.write(data);
                }
                int responseCode = connection.getResponseCode();
                Trace.d((String)TAG, (String)("doPost() responseCode:" + responseCode));
                if (200 == responseCode) {
                    result = HttpTools.getResultString(connection.getInputStream(), HttpTools.getParamsEncoding());
                } else {
                    Trace.d((String)TAG, (String)("Connection failed: " + connection.getResponseCode()));
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            connection.disconnect();
        }
        Trace.d((String)TAG, (String)("doPost() result:" + result));
        return result;
    }

    private static String getResultString(InputStream inputStream, String encode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int len = 0;
        String result = "";
        if (inputStream != null) {
            try {
                while ((len = inputStream.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
                result = new String(outputStream.toByteArray(), encode);
            }
            catch (IOException e) {
                Trace.d((String)TAG, (String)("getResultString() exception:" + e.toString()));
                e.printStackTrace();
            }
        }
        return result;
    }

    private static byte[] getParamsData(Map<String, String> params) {
        Trace.d((String)TAG, (String)"getParamsData() start.");
        byte[] data = null;
        try {
            if (null != params && !params.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    buffer.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), HttpTools.getParamsEncoding())).append("&");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                data = buffer.toString().getBytes(HttpTools.getParamsEncoding());
            }
        }
        catch (UnsupportedEncodingException e) {
            Trace.d((String)TAG, (String)("getParamsData() exception:" + e.toString()));
            e.printStackTrace();
        }
        return data;
    }

    public static String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public static String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + HttpTools.getParamsEncoding();
    }

    public String checkVersion(DeviceInfo deviceInfo, Context context) {
        String networkState = NetUtils.getNetworkState(context);
        String url = String.format("%s/product/%s/%s/ota/checkVersion", SDKConfig.HTTP_BASE_URL, deviceInfo.productId, RegisterInfo.getInstance().deviceId);
        TelephoneManager.build().init(context);
        String cid = TelephoneManager.build().getCid();
        String lac = TelephoneManager.build().getLac();
        String mcc = TelephoneManager.build().getMcc();
        String mnc = TelephoneManager.build().getMnc();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mid", (Object)DeviceInfo.getInstance().mid);
            jsonObject.put("version", (Object)DeviceInfo.getInstance().version);
            jsonObject.put("networkType", (Object)networkState);
            if (!TextUtils.isEmpty((CharSequence)cid) && cid.length() <= 100) {
                jsonObject.put("cid", (Object)cid);
            }
            if (!TextUtils.isEmpty((CharSequence)lac) && lac.length() <= 100) {
                jsonObject.put("lac", (Object)lac);
            }
            if (!TextUtils.isEmpty((CharSequence)mcc) && mcc.length() <= 100) {
                jsonObject.put("mcc", (Object)mcc);
            }
            if (!TextUtils.isEmpty((CharSequence)mnc) && mnc.length() <= 100) {
                jsonObject.put("mnc", (Object)mnc);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        InternalResponse response = HttpTools.doPostJson(url, jsonObject);
        String result = response.isResultOk() ? response.getResult().getMessage() : "";
        return result;
    }

    public String seqnoCreate() {
        StringBuffer buffer = new StringBuffer();
        long timeMillis = System.currentTimeMillis();
        buffer.append("D_").append(DeviceInfo.getInstance().mid).append(timeMillis);
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            int nextInt = random.nextInt(10);
            buffer.append(nextInt);
        }
        return buffer.toString();
    }

    public String doPostReportDownResult(DownParamInfo downParamInfo) {
        String url = String.format(SDKConfig.HTTP_BASE_URL + "/product/%s/%s/ota/reportDownResult", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        JSONObject body = new JSONObject();
        try {
            body.put("mid", (Object)downParamInfo.mid);
            body.put("deltaID", (Object)downParamInfo.deltaID);
            body.put("downloadStatus", (Object)downParamInfo.downloadStatus);
            body.put("downStart", (Object)downParamInfo.downStart);
            body.put("downEnd", (Object)downParamInfo.downEnd);
            body.put("downSize", downParamInfo.downSize);
            if (!TextUtils.isEmpty((CharSequence)downParamInfo.downIp)) {
                body.put("downIp", (Object)downParamInfo.downIp);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        InternalResponse response = HttpTools.doPostJson(url, body);
        return response.isResultOk() ? response.getResult().getMessage() : "";
    }

    public String doPostUpgradeResult(UpgradeParamInfo upgradeParamInfo) {
        String url = String.format(SDKConfig.HTTP_BASE_URL + "/product/%s/%s/ota/reportUpgradeResult", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        JSONObject body = new JSONObject();
        try {
            body.put("mid", (Object)upgradeParamInfo.mid);
            body.put("deltaID", (Object)upgradeParamInfo.deltaID);
            body.put("updateStatus", (Object)upgradeParamInfo.updateStatus);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        InternalResponse response = HttpTools.doPostJson(url, body);
        return response.isResultOk() ? response.getResult().getMessage() : "";
    }

    public void dopostMsgPushResponse(String msgId) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("msgId", (Object)msgId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String url = String.format(SDKConfig.HTTP_BASE_URL + "/product/%s/%s/notify/response", DeviceInfo.getInstance().productId, RegisterInfo.getInstance().deviceId);
        HttpTools.doPostJson(url, jsonObject);
    }
}

