/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.inter;

import com.adups.iot_libs.MqttAgentPolicy;
import com.adups.iot_libs.inter.IListener;
import com.adups.iot_libs.inter.ILoginCallback;
import com.adups.iot_libs.inter.IStatusListener;
import com.adups.iot_libs.inter.MessageListener;
import com.adups.iot_libs.interact.OtaTools;
import com.adups.mqtt_libs.connect.MqttManager;
import com.adups.mqtt_libs.mqttv3.IMqttActionListener;
import com.adups.mqtt_libs.mqttv3.IMqttToken;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.trace.Trace;
import java.util.HashMap;
import java.util.Map;

public class OtaListener
implements IMqttActionListener,
MessageListener.ConnectionLostListener {
    private static final String TAG = "OtaListener";
    private static OtaListener mInstance;
    Object mLock = new Object();
    private Action action;
    private Map<Enum, IListener> listeners = new HashMap<Enum, IListener>();

    @Override
    public void onConnectLost(int error) {
        IListener listener = this.getListener(Action.CONNECT);
        if (listener == null) {
            Trace.d((String)TAG, (String)"onConnectLost() connect listener is null");
            return;
        }
        if (-1 == error) {
            ((IStatusListener)listener).onDisconnected();
        } else {
            ((IStatusListener)listener).onAbnormalDisconnected(error);
            this.keepConnect();
        }
        this.setAction(Action.CONNECT);
        OtaTools.getInstance().setState(OtaTools.State.Disconnected);
    }

    private void keepConnect() {
        try {
            MqttManager.getInstance().getConnect().getClient().startKeepConnect(1800000L, System.currentTimeMillis() + 30000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OtaListener getInstance() {
        if (mInstance != null) return mInstance;
        Class<OtaListener> clazz = OtaListener.class;
        synchronized (OtaListener.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OtaListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public OtaListener setAction(Action action) {
        this.action = action;
        if (Action.CONNECT == action) {
            MessageListener.getInstance().setConnectionLostListener(this);
        }
        return this;
    }

    private OtaListener() {
    }

    public void addListener(Action action, IListener listener) {
        if (!this.listeners.containsKey((Object)action)) {
            this.listeners.put(action, listener);
        }
    }

    public void removeListener(Action action) {
        if (this.listeners.containsKey((Object)action)) {
            this.listeners.remove((Object)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(IMqttToken asyncActionToken) {
        switch (this.action) {
            case CONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket connect success");
                this.connect();
                break;
            }
            case DISCONNECT: {
                Trace.d((String)TAG, (String)"onSuccess() socket disconnect success");
                this.disConnect();
                break;
            }
            case PUB_REPORT_DEVICEINFO: {
                Trace.d((String)TAG, (String)"onSuccess() pub report deviceinfo");
                break;
            }
            case PUB_MSG_PUSH_RESPONSE: {
                Trace.d((String)TAG, (String)"onSuccess() pub msg push response");
                this.removeListener(Action.PUB_MSG_PUSH_RESPONSE);
                break;
            }
            case PUB_LOGIN: {
                Trace.d((String)TAG, (String)"onSuccess() pub login");
                this.removeListener(Action.PUB_LOGIN);
                break;
            }
            case PUB_LOGOUT: {
                Trace.d((String)TAG, (String)"onSuccess() pub logout");
                this.removeListener(Action.PUB_LOGOUT);
                break;
            }
            case SUB_LOGIN: {
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case SUB_LOGOUT: {
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case SUB_NOTIFY: {
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case SUB_REPORT_DEVICEINFO: {
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
        }
    }

    private void disConnect() {
    }

    private void connect() {
        OtaTools.getInstance().setState(OtaTools.State.Connected);
        IListener listener = this.getListener(Action.CONNECT);
        if (listener == null) {
            Trace.d((String)TAG, (String)"connect() connect listener is null");
            return;
        }
        this.doLogin(listener);
    }

    private void doLogin(final IListener listener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OtaListener.this.mLock;
                synchronized (object) {
                    try {
                        OtaTools.getInstance().subLogin();
                        OtaListener.this.mLock.wait();
                        OtaTools.getInstance().subLogout();
                        OtaListener.this.mLock.wait();
                        OtaTools.getInstance().subNotify();
                        OtaListener.this.mLock.wait();
                        OtaTools.getInstance().subReportDeviceInfo();
                        OtaListener.this.mLock.wait();
                        OtaTools.getInstance().login(new ILoginCallback(){

                            @Override
                            public void onLoginSuccess() {
                                ((IStatusListener)listener).onConnected();
                            }

                            @Override
                            public void onLoginFail(int error) {
                                MqttAgentPolicy.disConnect();
                            }

                            @Override
                            public void onLoginTimeout() {
                                MqttAgentPolicy.disConnect();
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private IListener getListener(Action action) {
        IListener iListener = this.listeners.get((Object)action);
        return iListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(IMqttToken token, Throwable exception) {
        Object object = this.mLock;
        synchronized (object) {
            switch (this.action) {
                case CONNECT: {
                    Trace.d((String)TAG, (String)"onFailure() connect");
                    this.connect(exception);
                    break;
                }
                case DISCONNECT: {
                    Trace.d((String)TAG, (String)"onFailure() disconnect");
                    this.disconnect(exception);
                    break;
                }
                case PUB_REPORT_DEVICEINFO: {
                    Trace.d((String)TAG, (String)"onFailure() pub report deviceinfo");
                    this.removeListener(Action.PUB_REPORT_DEVICEINFO);
                    break;
                }
                case PUB_MSG_PUSH_RESPONSE: {
                    Trace.d((String)TAG, (String)"onFailure() pub msg push response");
                    this.removeListener(Action.PUB_MSG_PUSH_RESPONSE);
                    break;
                }
                case PUB_LOGIN: {
                    Trace.d((String)TAG, (String)"onFailure() pub login");
                    this.removeListener(Action.PUB_LOGIN);
                    break;
                }
                case PUB_LOGOUT: {
                    Trace.d((String)TAG, (String)"onFailure() pub logout");
                    this.removeListener(Action.PUB_LOGOUT);
                    break;
                }
                case SUB_LOGIN: {
                    Trace.d((String)TAG, (String)"onFailure() sub login");
                    this.mLock.notify();
                    break;
                }
                case SUB_LOGOUT: {
                    Trace.d((String)TAG, (String)"onFailure() sub logout");
                    this.mLock.notify();
                    break;
                }
                case SUB_NOTIFY: {
                    Trace.d((String)TAG, (String)"onFailure() sub notify");
                    this.mLock.notify();
                    break;
                }
                case SUB_REPORT_DEVICEINFO: {
                    Trace.d((String)TAG, (String)"onFailure() sub report deviceinfo");
                    this.mLock.notify();
                }
            }
        }
    }

    private void disconnect(Throwable exception) {
        OtaTools.getInstance().setState(OtaTools.State.Disconnected);
        IListener listener = this.getListener(Action.CONNECT);
        if (listener == null) {
            return;
        }
        ((IStatusListener)listener).onError(this.getError(exception));
        if (null == exception) {
            return;
        }
        Trace.e((String)TAG, (String)("disconnect() exception:" + exception.toString()));
        exception.printStackTrace();
    }

    private void connect(Throwable exception) {
        OtaTools.getInstance().setState(OtaTools.State.Disconnected);
        IListener listener = this.getListener(Action.CONNECT);
        if (listener == null) {
            return;
        }
        ((IStatusListener)listener).onError(this.getError(exception));
        if (null != exception) {
            exception.printStackTrace();
            Trace.e((String)TAG, (String)("connect() " + exception.toString()));
        }
    }

    private int getError(Throwable exception) {
        if (exception instanceof MqttException) {
            MqttException mqttExc = (MqttException)exception;
            return mqttExc.getReasonCode();
        }
        return 6;
    }

    public static enum Action {
        CONNECT,
        DISCONNECT,
        PUB_REPORT_DEVICEINFO,
        PUB_MSG_PUSH_RESPONSE,
        PUB_LOGIN,
        PUB_LOGOUT,
        SUB_LOGIN,
        SUB_LOGOUT,
        SUB_NOTIFY,
        SUB_REPORT_DEVICEINFO;

    }
}

