/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.inter;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.adups.iot_libs.inter.ILoginCallback;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IReportDeviceStatusCallback;
import com.adups.iot_libs.inter.TimeoutCallback;
import com.adups.iot_libs.interact.HttpTools;
import com.adups.iot_libs.interact.OtaTools;
import com.adups.iot_libs.utils.JsonAnalyticsUtil;
import com.adups.iot_libs.utils.TimeUtils;
import com.adups.mqtt_libs.mqttv3.IMqttDeliveryToken;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.mqtt_libs.mqttv3.MqttException;
import com.adups.mqtt_libs.mqttv3.MqttMessage;
import com.adups.trace.Trace;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageListener
implements MqttCallback {
    private static final String TAG = "MessageListener";
    private static final String LOGOUT_RESPONSE = "logout/response";
    private static final String LOGIN_RESPONSE = "login/response";
    private static final String REPORT_DEVICE_STATUS_RESPONSE = "update/response";
    private static final String PUSH_NOTIFY = "notify";
    public static final int DISCONNECTED_OK = -1;
    private Context mCx;
    private ILoginCallback mILoginCallback;
    private ILogoutCallback mILogoutCallback;
    private IReportDeviceStatusCallback mIReportDeviceStatusCallback;
    private static final int RESPONSE_TIMEOUT = 5000;
    private boolean timeout = true;
    private static MessageListener messageListener;
    private ConnectionLostListener mConnectionLostListener;
    private State currentState = State.Null;

    private MessageListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageListener getInstance() {
        if (messageListener != null) return messageListener;
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            if (messageListener != null) return messageListener;
            messageListener = new MessageListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return messageListener;
        }
    }

    public void connectionLost(Throwable var1) {
        Trace.d((String)TAG, (String)"connectionLost() ");
        if (null != this.mConnectionLostListener) {
            int reasonCode = null != var1 && var1 instanceof MqttException ? ((MqttException)var1).getReasonCode() : (var1 == null ? -1 : 6);
            this.mConnectionLostListener.onConnectLost(reasonCode);
        }
    }

    public void messageArrived(String var1, MqttMessage var2) throws Exception {
        String message = new String(var2.getPayload());
        Trace.d((String)TAG, (String)("messageArrived() :" + var1));
        Trace.d((String)TAG, (String)("messageArrived() :" + message));
        if (this.currentState == State.Null) {
            Trace.d((String)TAG, (String)"messageArrived() state is null");
            return;
        }
        if (var1.endsWith(LOGIN_RESPONSE)) {
            String reply = this.getReply(message);
            if (OtaTools.getInstance().verifyReplyByNo(1000, reply)) {
                Trace.d((String)TAG, (String)"messageArrived() login response success!");
                this.timeout = false;
                int i = JsonAnalyticsUtil.responseJson(message);
                if (JsonAnalyticsUtil.responseSuccess(i)) {
                    this.mILoginCallback.onLoginSuccess();
                    OtaTools.getInstance().setState(OtaTools.State.Login);
                } else {
                    this.mILoginCallback.onLoginFail(i);
                }
            }
        } else if (var1.endsWith(LOGOUT_RESPONSE)) {
            String reply = this.getReply(message);
            if (OtaTools.getInstance().verifyReplyByNo(1001, reply)) {
                Trace.d((String)TAG, (String)"messageArrived() logout response success!");
                this.timeout = false;
                int i = JsonAnalyticsUtil.responseJson(message);
                if (JsonAnalyticsUtil.responseSuccess(i)) {
                    this.mILogoutCallback.onLogoutSuccess();
                    OtaTools.getInstance().setState(OtaTools.State.Logout);
                } else {
                    this.mILogoutCallback.onLogoutFail(i);
                }
            }
        } else if (var1.endsWith(REPORT_DEVICE_STATUS_RESPONSE)) {
            String reply = this.getReply(message);
            if (OtaTools.getInstance().verifyReplyByNo(1002, reply)) {
                Trace.d((String)TAG, (String)"messageArrived() report device info success");
                this.timeout = false;
                int i = JsonAnalyticsUtil.responseJson(message);
                if (JsonAnalyticsUtil.responseSuccess(i)) {
                    this.mIReportDeviceStatusCallback.onReportSuccess();
                } else {
                    this.mIReportDeviceStatusCallback.onReportFail(i);
                }
            }
        } else if (var1.endsWith(PUSH_NOTIFY)) {
            JSONObject jsonObject = new JSONObject(message);
            Intent intent = new Intent();
            intent.setAction("action_fota_notify");
            intent.putExtra("key_fota_notify", jsonObject.toString());
            LocalBroadcastManager.getInstance((Context)this.mCx).sendBroadcast(intent);
            if (jsonObject.has("msgId")) {
                final String msgId = jsonObject.getString("msgId");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HttpTools.getInstance().dopostMsgPushResponse(msgId);
                    }
                }).start();
            }
        }
    }

    private String getReply(String message) {
        try {
            JSONObject jsonObject = new JSONObject(message);
            if (jsonObject.has("replyno")) {
                String replyno = jsonObject.getString("replyno");
                return replyno;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void deliveryComplete(IMqttDeliveryToken var1) {
    }

    private void response(String action, boolean b) {
        Trace.d((String)TAG, (String)("response() start. action = " + action));
        if (null == this.mCx) {
            Trace.d((String)TAG, (String)"response() Context is null!");
            return;
        }
        Intent intent = new Intent();
        intent.setAction(action);
        intent.putExtra("key_fota_response", b);
        LocalBroadcastManager.getInstance((Context)this.mCx).sendBroadcast(intent);
    }

    public void setLoginListener(ILoginCallback listener) {
        this.mILoginCallback = listener;
        this.setCurrentState(State.Login);
        this.timeStart();
    }

    public void setLogoutListener(ILogoutCallback listener) {
        this.mILogoutCallback = listener;
        this.setCurrentState(State.Logout);
        this.timeStart();
    }

    public void setReportDeviceStatusListener(IReportDeviceStatusCallback listener) {
        this.mIReportDeviceStatusCallback = listener;
        this.setCurrentState(State.ReportDeviceInfo);
        this.timeStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStart() {
        Trace.d((String)TAG, (String)"timeStart() ");
        Class<MessageListener> clazz = MessageListener.class;
        synchronized (MessageListener.class) {
            TimeUtils.get().startTime(new TimeoutCallback(){

                @Override
                public void onTimeout() {
                    if (MessageListener.this.timeout) {
                        if (MessageListener.this.currentState == State.Login) {
                            MessageListener.this.mILoginCallback.onLoginTimeout();
                        }
                        if (MessageListener.this.currentState == State.Logout) {
                            MessageListener.this.mILogoutCallback.onLogoutTimeout();
                        }
                        if (MessageListener.this.currentState == State.ReportDeviceInfo) {
                            MessageListener.this.mIReportDeviceStatusCallback.onReportFail(32000);
                        }
                        MessageListener.this.setCurrentState(State.Null);
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void setCurrentState(State currentState) {
        this.timeout = true;
        this.currentState = currentState;
    }

    public void setConnectionLostListener(ConnectionLostListener listener) {
        this.mConnectionLostListener = listener;
    }

    public static interface ConnectionLostListener {
        public void onConnectLost(int var1);
    }

    static enum State {
        Null,
        Login,
        Logout,
        ReportDeviceInfo;

    }
}

