/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.info;

import android.content.Context;
import android.text.TextUtils;
import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.constant.Error;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.trace.Trace;

public class RegisterInfo {
    private static RegisterInfo registerInfo;
    public String deviceSecret;
    public String deviceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterInfo getInstance() {
        if (registerInfo != null) return registerInfo;
        Class<RegisterInfo> clazz = RegisterInfo.class;
        synchronized (RegisterInfo.class) {
            if (registerInfo != null) return registerInfo;
            registerInfo = new RegisterInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registerInfo;
        }
    }

    public void init(Context context) {
        String device_secret = SPFTool.getString(context, "deviceSecret", "");
        String deviceId = SPFTool.getString(context, SPFTool.KEY_DEVICE_ID, "");
        if (TextUtils.isEmpty((CharSequence)device_secret) || TextUtils.isEmpty((CharSequence)deviceId)) {
            Trace.d((String)"RegisterInfo", (String)"init() first register");
            OtaAgentPolicy.register(new IRegisterListener(){

                @Override
                public void onSuccess() {
                    Trace.d((String)"RegisterInfo", (String)"init() register success ");
                }

                @Override
                public void onFailed(int error) {
                    Trace.w((String)"RegisterInfo", (String)("init() register fail, " + Error.getErrorMessage(error)));
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)device_secret)) {
            this.deviceSecret = device_secret;
        }
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            this.deviceId = deviceId;
        }
    }
}

