/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.adups.iot_libs.security.FotaException;
import com.adups.trace.Trace;
import java.lang.reflect.Method;

public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private static final String KEY_MOBILE_PARAMS = "key_mobile_params";
    public String mid;
    public String productId;
    public String product_secret;
    public String version;
    public String oem;
    public String models;
    public String platform;
    public String deviceType;
    public static DeviceInfo mInstance;
    public static Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceInfo getInstance() {
        if (mInstance != null) return mInstance;
        Class<DeviceInfo> clazz = DeviceInfo.class;
        synchronized (DeviceInfo.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DeviceInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void initContext(Context context) {
        mContext = context;
    }

    public void initInfo(String mid) throws FotaException {
        Trace.d((String)TAG, (String)"--------------initInfo--------------");
        this.mid = mid;
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            String id = applicationInfo.metaData.getString("fota_configuration_product_id");
            String secret = applicationInfo.metaData.getString("fota_configuration_product_secret");
            if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)secret) || !id.startsWith("string/") || !secret.startsWith("string/")) {
                throw new FotaException(203);
            }
            this.productId = id.replace("string/", "");
            this.product_secret = secret.replace("string/", "");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            throw new FotaException(e);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new FotaException(203, (Throwable)e);
        }
        try {
            ClassLoader cl = mContext.getClassLoader();
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class};
            Method get = SystemProperties.getMethod("get", paramTypes);
            this.version = (String)get.invoke(SystemProperties, "ro.fota.version");
            this.oem = (String)get.invoke(SystemProperties, "ro.fota.oem");
            this.models = (String)get.invoke(SystemProperties, "ro.fota.device");
            this.platform = (String)get.invoke(SystemProperties, "ro.fota.platform");
            this.deviceType = (String)get.invoke(SystemProperties, "ro.fota.type");
        }
        catch (Exception e) {
            throw new FotaException(202, (Throwable)e);
        }
    }

    public boolean initOtherInfo(String mid, String version, String oem, String models, String platform, String deviceType) throws FotaException {
        Trace.d((String)TAG, (String)"-------------initOtherInfo------------- ");
        this.mid = mid;
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            String id = applicationInfo.metaData.getString("fota_configuration_product_id");
            String secret = applicationInfo.metaData.getString("fota_configuration_product_secret");
            if (TextUtils.isEmpty((CharSequence)id) || TextUtils.isEmpty((CharSequence)secret) || !id.startsWith("string/") || !secret.startsWith("string/")) {
                throw new FotaException(203);
            }
            this.productId = id.replace("string/", "");
            this.product_secret = secret.replace("string/", "");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            throw new FotaException(e);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new FotaException(203, (Throwable)e);
        }
        this.oem = oem;
        this.models = models;
        this.platform = platform;
        this.deviceType = deviceType;
        this.version = version;
        boolean valid = this.isValid();
        Trace.d((String)TAG, (String)String.format("mid:%s,productId:%s,product_secret:%s,version:%s,oem:%s,models:%s,platform:%s,deviceType:%s", mid, this.productId, this.product_secret, version, oem, models, platform, deviceType));
        return valid;
    }

    public boolean isValid() {
        boolean valid = true;
        if (TextUtils.isEmpty((CharSequence)this.mid)) {
            Trace.d((String)TAG, (String)"isValid() mid = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() productId = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.oem)) {
            Trace.d((String)TAG, (String)"isValid() oem = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.models)) {
            Trace.d((String)TAG, (String)"isValid() models = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.platform)) {
            Trace.d((String)TAG, (String)"isValid() platform = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.deviceType)) {
            Trace.d((String)TAG, (String)"isValid() deviceType = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.product_secret)) {
            Trace.d((String)TAG, (String)"isValid() product_secret = null");
            valid = false;
        }
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            Trace.d((String)TAG, (String)"isValid() product id = null");
            valid = false;
        }
        return valid;
    }

    public String toString() {
        return "DeviceInfo{mid'" + this.mid + '\'' + "productId" + "'" + this.productId + '\'' + "oem" + "'" + this.oem + '\'' + "model" + "'" + this.models + '\'' + "platform" + "'" + this.platform + '\'' + "deviceType" + "'" + this.deviceType + '\'' + "product secret" + "'" + this.product_secret + '\'' + "product id" + "'" + this.productId + '\'' + '}';
    }
}

