/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.engine;

import android.content.Context;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;

public class TelephoneManager {
    private static TelephoneManager telephoneManager;
    private Context mCx;
    private TelephonyManager mTelephonyManager;
    private static final String TAG = "TelephoneManager";
    private String operator;
    private GsmCellLocation location;

    public static TelephoneManager build() {
        if (null == telephoneManager) {
            telephoneManager = new TelephoneManager();
        }
        return telephoneManager;
    }

    public TelephoneManager init(Context context) {
        this.mCx = context;
        try {
            this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            this.operator = this.mTelephonyManager.getNetworkOperator();
            this.location = (GsmCellLocation)this.mTelephonyManager.getCellLocation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getLac() {
        String lac = "";
        try {
            lac = String.valueOf(this.location.getLac());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lac;
    }

    public String getCid() {
        String cid = "";
        try {
            cid = String.valueOf(this.location.getCid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cid;
    }

    public String getMcc() {
        String mcc = "";
        try {
            mcc = String.valueOf(Integer.parseInt(this.operator.substring(0, 3)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcc;
    }

    public String getMnc() {
        String mnc = "";
        try {
            mnc = String.valueOf(Integer.parseInt(this.operator.substring(3)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mnc;
    }
}

