/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.engine;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import com.adups.trace.Trace;

public class FotaVerifyManager {
    private static final String TAG = "FotaVerifyManager";
    private static final String[] PERMISSIONS = new String[]{"android.permission.INTERNET", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WAKE_LOCK", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.RECEIVE_BOOT_COMPLETED", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_COARSE_LOCATION"};
    private static final String[] RECEIVER_ELEMENTS = new String[]{"com.adups.iot_libs.receiver.UpgradeReceiver"};
    private static final String[] SERVICE_ELEMENTS = new String[]{"com.adups.iot_libs.service.OtaService", "com.adups.mqtt_libs.mqtt_service.MqttService"};
    private static final String[] SERVICE_LOLLIPOP_ELEMENTS = new String[]{"com.adups.iot_libs.service.OtaService", "com.adups.mqtt_libs.mqtt_service.MqttService", "com.adups.iot_libs.service.JobSchedulerService"};

    public static boolean verify(Context context) {
        boolean permission = FotaVerifyManager.verifyPermissions(context);
        boolean element = FotaVerifyManager.verifyElement(context);
        return permission ? element : false;
    }

    private static boolean verifyPermissions(Context context) {
        PackageManager packageManager = context.getPackageManager();
        StringBuilder buffer = new StringBuilder();
        try {
            String[] requestedPermissions = packageManager.getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            for (int i = 0; i < PERMISSIONS.length; ++i) {
                String needPermission = PERMISSIONS[i];
                boolean b = false;
                if (requestedPermissions != null) {
                    for (String requestedPermission : requestedPermissions) {
                        if (!requestedPermission.equals(needPermission)) continue;
                        b = true;
                    }
                }
                if (b) continue;
                if (buffer.length() <= 0) {
                    buffer.append("please add permissions in AndroidManifest:\n");
                }
                buffer.append(needPermission).append("\n");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (buffer.length() == 0) {
            return true;
        }
        Trace.e((String)TAG, (String)buffer.toString());
        return false;
    }

    private static boolean verifyElement(Context context) {
        PackageManager packageManager = context.getPackageManager();
        boolean service = FotaVerifyManager.verifyServiceElement(packageManager, context);
        boolean receiver = FotaVerifyManager.verifyReceiverElement(packageManager, context);
        return service && receiver;
    }

    private static boolean verifyReceiverElement(PackageManager packageManager, Context context) {
        StringBuilder buffer = new StringBuilder();
        try {
            ActivityInfo[] receivers = packageManager.getPackageInfo((String)context.getPackageName(), (int)2).receivers;
            for (int i = 0; i < RECEIVER_ELEMENTS.length; ++i) {
                String needReceiverElement = RECEIVER_ELEMENTS[i];
                boolean b = false;
                if (receivers != null) {
                    for (int j = 0; j < receivers.length; ++j) {
                        ActivityInfo receiver = receivers[j];
                        String receiverName = receiver.name;
                        if (!receiverName.equals(needReceiverElement)) continue;
                        b = true;
                    }
                }
                if (b) continue;
                if (buffer.length() == 0) {
                    buffer.append("please add Receiver in AndroidManifest:\n");
                }
                buffer.append(needReceiverElement).append("\n");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (buffer.length() == 0) {
            return true;
        }
        Trace.e((String)TAG, (String)buffer.toString());
        return false;
    }

    private static boolean verifyServiceElement(PackageManager packageManager, Context context) {
        StringBuilder buffer = new StringBuilder();
        try {
            ServiceInfo[] services = packageManager.getPackageInfo((String)context.getPackageName(), (int)4).services;
            String[] need_services = Build.VERSION.SDK_INT >= 21 ? SERVICE_LOLLIPOP_ELEMENTS : SERVICE_ELEMENTS;
            for (int i = 0; i < need_services.length; ++i) {
                String needReceiverElement = need_services[i];
                boolean b = false;
                if (services != null) {
                    for (int j = 0; j < services.length; ++j) {
                        ServiceInfo service = services[j];
                        String receiverName = service.name;
                        if (!receiverName.equals(needReceiverElement)) continue;
                        b = true;
                    }
                }
                if (b) continue;
                if (buffer.length() == 0) {
                    buffer.append("please add Service in AndroidManifest:\n");
                }
                buffer.append(needReceiverElement).append("\n");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (buffer.length() == 0) {
            return true;
        }
        Trace.e((String)TAG, (String)buffer.toString());
        return false;
    }
}

