/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs;

import android.content.Context;
import com.adups.http_libs.engine.HttpManager;
import com.adups.iot_libs.MqttAgentPolicy;
import com.adups.iot_libs.constant.SDKConfig;
import com.adups.iot_libs.engine.FotaVerifyManager;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.RegisterInfo;
import com.adups.iot_libs.info.VersionInfo;
import com.adups.iot_libs.inter.ICheckVersionCallback;
import com.adups.iot_libs.inter.IDownloadListener;
import com.adups.iot_libs.inter.IRebootUpgradeCallBack;
import com.adups.iot_libs.inter.IRegisterListener;
import com.adups.iot_libs.security.FotaException;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.FileUtil;
import com.adups.iot_libs.utils.MyHostnameVerifier;
import com.adups.iot_libs.utils.Utils;
import com.adups.trace.Trace;
import java.io.File;
import javax.net.ssl.HostnameVerifier;

public class OtaAgentPolicy {
    public static Context sCx;
    private static String mPath;
    private static final String TAG = "OtaAgentPolicy";
    public static HttpManager httpManager;

    public static void initFota(Context context) throws FotaException {
        Trace.setLevel((int)3);
        Trace.setLog_path((String)Utils.setFotaLog(context));
        Trace.setShowPosition((boolean)true);
        Trace.d((String)TAG, (String)"-----------initFota---------");
        sCx = context;
        mPath = sCx.getFilesDir() + File.separator + "update.zip";
        SDKConfig.isTest(false);
        OtaAgentPolicy.verifyManifest(context);
        OtaService.initContext(context);
        DeviceInfo.initContext(context);
        MqttAgentPolicy.initMqtt();
        httpManager = HttpManager.build((Context)sCx).setRedirectTimes(0).setRetryTimes(0).setSSL(new String(SDKConfig.KEY), "/assets/adcom.bks", (HostnameVerifier)new MyHostnameVerifier()).create();
    }

    public static boolean setUpdatePath(String path) {
        Trace.d((String)TAG, (String)("setUpdatePath() :" + path));
        boolean existsDir = FileUtil.createOrExistsDir(new File(path).getParentFile().getAbsolutePath());
        if (existsDir) {
            Trace.e((String)TAG, (String)"setUpdatePath() path is invalid!");
            mPath = path;
        }
        return existsDir;
    }

    public static void showTrace(boolean show) {
        Trace.setLevel((int)(show ? 3 : 7));
    }

    public static void setDeviceInfo(String mid) throws FotaException {
        DeviceInfo.getInstance().initInfo(mid);
        RegisterInfo.getInstance().init(sCx);
    }

    public static void setTestDeviceInfo(String mid, String version, String oem, String models, String platform, String deviceType) throws FotaException {
        DeviceInfo.getInstance().initOtherInfo(mid, version, oem, models, platform, deviceType);
        RegisterInfo.getInstance().init(sCx);
    }

    public static void register(IRegisterListener iRegisterListener) {
        Trace.d((String)TAG, (String)"-----------register-----------");
        OtaService.setRegisterListener(iRegisterListener);
        OtaService.startByAction("action_register");
    }

    public static VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    public static void checkVersion(ICheckVersionCallback iCheckVersionCallback) {
        Trace.d((String)TAG, (String)"-----------checkVersion-----------");
        OtaService.setCheckVersionListener(iCheckVersionCallback);
        OtaService.startByAction("action_check_version");
    }

    public static void download(IDownloadListener onDownloadListener) {
        Trace.d((String)TAG, (String)"-----------download----------- ");
        OtaService.setDownloadListener(onDownloadListener);
        OtaService.startByAction("action_download");
    }

    public static void downloadCancel() {
        Trace.d((String)TAG, (String)"downloadCancel().");
        OtaService.setDownloadCancel();
    }

    public static void rebootUpgrade(IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"-----------rebootUpgrade-----------");
        OtaService.startByAction("action_update");
        OtaService.setUpdateCallBack(iRebootUpgradeCallBack);
    }

    public static void rebootLocalUpgrade(String path, IRebootUpgradeCallBack iRebootUpgradeCallBack) {
        Trace.d((String)TAG, (String)"-----------rebootLocalUpgrade----------- ");
        OtaService.startByAction("action_update");
        OtaService.setUpdateCallBack(iRebootUpgradeCallBack);
        OtaService.setLocalUpgrade(path);
    }

    public static String getPackagePath() {
        if (null == mPath) {
            Trace.d((String)TAG, (String)"getPackagePath() path is null,please call method initFota()!");
            return null;
        }
        return mPath;
    }

    private static boolean verifyManifest(Context context) {
        boolean fota_verify = FotaVerifyManager.verify(context);
        if (!fota_verify) {
            throw new RuntimeException("AndroidManifest element and permissions is lack");
        }
        return true;
    }
}

