/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs;

import com.adups.iot_libs.OtaAgentPolicy;
import com.adups.iot_libs.inter.ILoginCallback;
import com.adups.iot_libs.inter.ILogoutCallback;
import com.adups.iot_libs.inter.IReportDeviceStatusCallback;
import com.adups.iot_libs.inter.IStatusListener;
import com.adups.iot_libs.inter.MessageListener;
import com.adups.iot_libs.inter.OtaListener;
import com.adups.iot_libs.interact.OtaTools;
import com.adups.iot_libs.service.OtaService;
import com.adups.mqtt_libs.connect.MqttManager;
import com.adups.mqtt_libs.mqttv3.MqttCallback;
import com.adups.trace.Trace;

public class MqttAgentPolicy {
    public static void initMqtt() {
        MqttManager.getInstance().setContext(OtaAgentPolicy.sCx);
        MqttManager.getInstance().registerMessageListener((MqttCallback)MessageListener.getInstance());
        MqttManager.getInstance().setTraceEnable(false);
    }

    public static void registerStatusListener(IStatusListener listener) {
        OtaListener.getInstance().addListener(OtaListener.Action.CONNECT, listener);
    }

    public static void disConnect() {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"disConnect() is disconnected");
            return;
        }
        if (OtaTools.getInstance().getState() == OtaTools.State.Disconnecting) {
            Trace.d((String)"MqttAgentPolicy", (String)"disConnect() is disconnecting");
            return;
        }
        OtaService.startByAction("action_disconnect");
    }

    public static void connect() {
        if (MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"connect() is connected");
            return;
        }
        if (OtaTools.getInstance().getState() == OtaTools.State.Connecting) {
            Trace.d((String)"MqttAgentPolicy", (String)"connect() is connecting");
            return;
        }
        OtaService.startByAction("action_connect");
    }

    public static void reportDeviceStatus(String message, IReportDeviceStatusCallback callback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"reportDeviceStatus() is disconnected");
            return;
        }
        if (OtaTools.getInstance().getState() != OtaTools.State.Login) {
            Trace.e((String)"MqttAgentPolicy", (String)"reportDeviceStatus() device is off line");
            return;
        }
        OtaTools.getInstance().reportDeviceInfo(message, callback);
    }

    public static void reportDeviceStatus(IReportDeviceStatusCallback callback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.e((String)"MqttAgentPolicy", (String)"reportDeviceStatus() is disconnected");
            return;
        }
        if (OtaTools.getInstance().getState() != OtaTools.State.Login) {
            Trace.e((String)"MqttAgentPolicy", (String)"reportDeviceStatus() device is off line");
            return;
        }
        OtaTools.getInstance().reportDeviceInfo(callback);
    }

    public static void login(ILoginCallback loginCallback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"login() is disconnected");
            return;
        }
        OtaTools.getInstance().login(loginCallback);
    }

    public static void logout(ILogoutCallback logoutCallback) {
        if (!MqttManager.getInstance().isConneect()) {
            Trace.d((String)"MqttAgentPolicy", (String)"logout() is disconnected");
            return;
        }
        OtaTools.getInstance().logout(true, logoutCallback);
    }

    public static boolean isConnected() {
        return MqttManager.getInstance().isConneect();
    }
}

